"""
screen_start.py
opening game screen
"""

import pygame
import gfx, snd

from player import LocalPlayer, Player
from ai import AIPlayer
import screen_play


class Button(object):
    def __init__(self, action, imagehi, imagelo, rect, data):
        self.action = action
        self.imagehi = imagehi
        self.imagelo = imagelo
        self.rect = rect
        self.data = data
        self.pos = -rect.left - 280.0 - self.rect.top * 1.0
        self.move = 1.0
    
    def anim(self, time):
        if self.move:
            self.pos += time * self.move * 2.0
            if self.move > 0.0:
                if self.pos >= self.rect.left:
                    self.pos = self.rect.left
                    self.move = 0.0
            else:
                if self.pos < -self.rect.width:
                    return False
        return True
        
    def over(self, pos):
        return self.action and not self.move and self.rect.collidepoint(pos)

    def shrink(self):
        if not self.move:
            self.pos = self.rect.left + self.rect.top * 1.0
        self.move = -1.3

    def draw(self, gfx, hilite):
        r = pygame.Rect(self.rect)
        if self.move:
            r.left = min(self.pos, self.rect.left)
        if hilite:
            gfx.draw(self.imagelo, r)
        else:
            gfx.draw(self.imagehi, r)




class Screen(object):
    def __init__(self, next_screen):
        self.next_screen = next_screen
        self.on_button = None
        self.buttons = []
        self.mouse = pygame.mouse.get_pos()
        self.usekey = False
        self.background = gfx.key(gfx.load('titlescreen'))
        self.tile = [gfx.load('titletile')]
        self.tile.append(pygame.transform.flip(self.tile[0],1,1))

        self.menu_main = [
            ("Main Menu", None, None), #title
            ("Battle", self.setupsinglemenu, None),
            ("Demo", self.setupmultimenu, None),
            ("Information", self.setupinfomenu, None),
            ("Quit", self.setupnomenu, None),
        ]
        self.menu_single = [
            ("Computer Skill Level", None, None),
            ("Normal", self.start_ai_normal, None),
            ("Difficult", self.start_ai_difficult, None),
            ("Main Menu", self.setupmainmenu, None),
        ]
        self.menu_multi = [
            ("Demo Games", None, None),
            ("Free Play", self.hostgame, None),
            ("Computer vs Computer", self.clientgame, None),
            ("Main Menu", self.setupmainmenu, None),
        ]
        self.menu_color = [
            ("Select Your Color", None, None),
            ((gfx.loadcoloredkey("block",(250,50,50)), gfx.loadcoloredkey("block",(250,150,150))), self.start_ai_game,  (250,50,50)),
            ((gfx.loadcoloredkey("block",(50,50,250)), gfx.loadcoloredkey("block",(150, 150, 250))), self.start_ai_game, (50,50,250)),
            ((gfx.loadcoloredkey("block",(250,250,50)), gfx.loadcoloredkey("block",(250,250,150))), self.start_ai_game, (250,250,50)),
            ((gfx.loadcoloredkey("block",(250,50,250)), gfx.loadcoloredkey("block",(250,150,250))), self.start_ai_game, (250,50,250)),
            ((gfx.loadcoloredkey("block",(50,250,250)), gfx.loadcoloredkey("block",(150,250,250))), self.start_ai_game, (50,250,250)),
        ]
        self.menu_info = [
            ("Information", None, None),
            ("Snag is a quick paced game of capturing cells on a grid", None, None),
            ("to expand your color territory. Infect grid cells by enclosing", None, None),
            ("it with walls. If the neighboring cell has only three walls", None, None),
            ("you will also infect the neighboring cell. This can cause", None, None),
            ("chan reactions giving you many cells with only one wall placed.", None, None),
            ("                         ", None, None),
            ("Practice in the demo mode using free play, or watch two", None, None),
            ("computer opponents go head to head.", None, None),
            #("", None, None),
            ("Main Menu", self.setupmainmenu, None),
        ]
        self.setupmainmenu()



    def event(self, event):
        if event.type == pygame.KEYDOWN:
            self.setupmenu(None)
            self.usekey = True
        elif event.type == pygame.MOUSEMOTION:
            self.mouse = pygame.mouse.get_pos()
            self.usekey = False
        elif event.type == pygame.MOUSEBUTTONDOWN:
            if self.on_button and self.on_button.action:
                self.justpressed = self.on_button
                self.on_button.action()
        
        
    def update(self, time):
        #clear
        tilew, tileh = self.tile[0].get_size()
        shiftx = int(pygame.time.get_ticks() * 0.1) % tilew
        #shifty = int(pygame.time.get_ticks() * -0.03) % tileh
        gfx.Surf.set_clip(pygame.Rect(243, 0, tilew, tileh))
        gfx.Surf.blit(self.tile[0], (243-shiftx, 0))
        gfx.Surf.blit(self.tile[0], (243-shiftx+tilew, 0))
        gfx.Surf.set_clip()
        gfx.clear(self.background)
        
        #handle menu buttons
        if not self.usekey and self.on_button and not self.on_button.over(self.mouse):
            self.on_button = None
        for b in self.buttons[:]:
            if b.anim(time):
                if not self.usekey and not self.on_button and b.over(self.mouse):
                    self.on_button = b
                b.draw(gfx, self.on_button is b)
            else:
                self.buttons.remove(b)

        gfx.Surf.blit(self.background, (0, 0), (0, 0, 5, 450))


        #finish
        if not self.buttons:
            return self.next_screen
        return self


    def setupmenu(self, menu):
        snd.play('sweep')
        top = 120
        self.on_button = None
        for b in self.buttons:
            b.shrink()
        c = [70, 70, 220]
        bgd = 150, 150, 240
        if menu:
            spaces = menu[1]#, menu[-1]
            for item in menu:
                if item in spaces:
                    top += 20
                if type(item[0]) == str:
                    if len(item[0]) < 22:
                        size = 50
                    else:
                        size = 24
                    lopic = gfx.text(size, c, bgd, item[0], topleft=(80, top))
                    hipic = gfx.text(size, (200,200,250), bgd, item[0], topleft=(80, top))
                else:
                    lopic = item[0][0], item[0][0].get_rect().move((80,top))
                    hipic = item[0][1], item[0][1].get_rect().move((80,top))
                    size = item[0][0].get_rect().height - 15
                if not menu.index(item):
                    size += 10
                    lopic[1].left -= 20
                b = Button(item[1], lopic[0], hipic[0], lopic[1], item[2])
                self.buttons.append(b)
                top += size + 5
                c[0] += 12
                c[2] -= 5


    def setupnomenu(self):
        return self.setupmenu(None)
    def setupmainmenu(self):
        return self.setupmenu(self.menu_main)
    def setupsinglemenu(self):
        return self.setupmenu(self.menu_single)
    def setupmultimenu(self):
        return self.setupmenu(self.menu_multi)
    def setupinfomenu(self):
        return self.setupmenu(self.menu_info)

    def start_ai_game(self):
        player = LocalPlayer(self.justpressed.data)
        self.next_screen = screen_play.Screen(self, player, self.opponent)
        self.opponent = None
        self.setupmenu(None)

    def start_ai_normal(self):
        self.opponent = AIPlayer((50, 250, 50), 1)
        self.setupmenu(self.menu_color)
    
    def start_ai_difficult(self):
        self.opponent = AIPlayer((50, 250, 50), 3)
        self.setupmenu(self.menu_color)

    def hostgame(self):
        player = LocalPlayer((250, 200, 150))
        opponent = Player((50, 250, 50))
        self.next_screen = screen_play.Screen(self, player, opponent)
        self.setupmenu(None)
    
    def clientgame(self):
        player = AIPlayer((250, 50, 50), 3)
        opponent = AIPlayer((50, 50, 250), 3)
        self.next_screen = screen_play.Screen(self, player, opponent, interval=300.0)
        self.setupmenu(None)