"""
player.py

base player class and local player
"""

import random
import pygame
import gfx



class Player(object):
    """base player class"""
    def __init__(self, color):
        self.score = 0
        self.getinput = 0
        self.playing = 0
        self.currentmove = None
        self.chat = None
        self.color = color
        self.chosenwall = None
        texture = 'texture' + str(random.randint(1,8))
        self.image = gfx.loadcolored(texture, color)
        self.missimg = gfx.loadcoloredkey('miss', color)
        self.winimg = gfx.loadcoloredkey('win', color)
        self.loseimg = gfx.loadcoloredkey('lose', color)
        
        hicolor = [min(int(c*1.3),255) for c in color]
        hicolor2 = [min(int(c*1.3)+20,255) for c in color]
        self.hicolor = hicolor2
        self.scorebar = gfx.loadcoloredkey('scorebar', hicolor)
        
        self.glows = []
        rs = (255-color[0])/5.0
        rg = (255-color[1])/5.0
        rb = (255-color[2])/5.0
        r = g = b = 255.0
        for x in range(5):
            c = map(int, (r,g,b))
            self.glows.append(gfx.loadcoloredkey('glow', c))
            r -= rs
            g -= rg
            b -= rb
            
    def newturn(self):
        pass

    def update(self, map):
        pass
        




class LocalPlayer(Player):
    def __init__(self, color):
        Player.__init__(self, color)
        self.getinput = 1
        self.playing = 1


    def update(self, map):
        if self.chosenwall and map.walls[self.chosenwall]:
            self.chosenwall = None        


