"""
hud.py
onscreen elements during ingame
"""

import pygame
import gfx


class Watch(object):
    def __init__(self, pos):
        self.face = gfx.key(gfx.load('clockface'))
        self.facerect = self.face.get_rect()
        self.facerect.topleft = pos
        self.hand = gfx.key(gfx.load('clockhand'))

    def draw(self, abstime):
        angle = max(int(abstime * 400) % 390-40,0) #/ 10 * 10
        rothand = pygame.transform.rotate(self.hand, angle)
        rothand.set_alpha(255)
        r = rothand.get_rect()
        r.center = self.facerect.center
        
        gfx.draw(self.face, self.facerect)
        gfx.draw(rothand, r)


class EffectsList(object):
    def __init__(self):
        self.effects = []
    
    def append(self, item):
        self.effects.append(item)
    
    def clear(self):
        del self.effects[:]
        
    def update(self, time):
        for i in self.effects[:]:
            if not i.update(time):
                self.effects.remove(i)


class Drift(object):
    def __init__(self, img, pos, length):
        self.img = img
        self.pos = [float(pos[0]), float(pos[1])-15.0]
        self.rect = img.get_rect()
        self.rect.center = pos
        self.length = float(length)
        self.time = 0.0
        
    def update(self, time):
        self.time += time
        if self.time > self.length:
            return False
        self.pos[1] -= time * .05
        self.rect.center = self.pos
        gfx.draw(self.img, self.rect)
        return True


class Glow(object):
    def __init__(self, imgs, pos):
        self.pos = pos
        self.imgs = imgs
        self.numimgs = len(imgs)
        self.length = 150.0
        self.time = 0.0
    
    def update(self, time):
        self.time += time
        if self.time >= self.length:
            return False
        img = self.imgs[int((self.time / self.length) * self.numimgs)]
        gfx.draw(img, self.pos)
        return True
        
