"""
ai.py
computer opponent player
"""

import random
from player import Player


class AIPlayer(Player):
    def __init__(self, color, smart=3):
        Player.__init__(self, color)
        self.playing = 1
        self.smart = smart
        self.interest = random.randint(2, 22), random.randint(2, 14)
        self.tries = 0
        self.range = smart+1
        self.skipturn = 0
        if self.smart <3:
            self.skipturn = 1

    def newturn(self):
        if self.skipturn:
            self.skipturn -= 1
        elif self.smart <= 2:
            self.skipturn = random.randint(0,50) == 22

    def update(self, map):
        if self.skipturn:
            return

        if not self.chosenwall:
            choices = []
            goodchoices = []
            sx = max(0, self.interest[0]-self.range)
            sy = max(0, self.interest[1]-self.range)
            if self.tries >= self.smart:
                for x in range(sx, min(sx+6,26)):
                    for y in range(sy, min(sy+6, 17)):
                        if not map.walls[x,y,0]:
                            choices.append((x,y,0))
                        if not map.walls[x,y,1]:
                            choices.append((x,y,1))
            else:
                for x in range(sx, min(sx+self.range*2,25)):
                    for y in range(sy, min(sy+self.range*2, 16)):
                        cell = map.cells[x,y]
                        open = map.cellclosedthree(cell)
                        if not open:
                            continue
                        if self.smart > 2:
                            bothsides = map.wallcells(open)
                            if cell is bothsides[0]:
                                nextcheck = bothsides[1]
                            else:
                                nextcheck = bothsides[0]
                            closeds = map.cellclosedcount(nextcheck)
                            if closeds == 2 or closeds == 3:
                                goodchoices.append(open)
                        choices.append(open)
            choices = goodchoices or choices
            if choices:
                self.chosenwall = random.choice(choices)
                self.interest = self.chosenwall[:2]
                self.tries = 0
            else:
                self.interest = random.randint(2, 22), random.randint(2, 14)
                self.tries += 1
        else:
            if map.walls[self.chosenwall]:
                self.chosenwall = None


