"""
Module cooties_engine
Game logic for You've Got COOTIES!
"""

import random

class UglyHack(Exception): pass

class Board(object):
    rows = 15
    cols = 10
    
    def __init__(self):
        self.cells = [[random.randint(0, 2) for x in range(self.rows)]
                                            for y in range(self.cols)]
        self.pills = [None, None, None]
        self.selected_pill = None
        self.turns = 0

    def random_pill(self):
        return random.choice((0, 0, 0, 1, 2, 2, 3))

    def shake_bottle(self):
        if self.pills == [None, None, None]:
            self.pills = [self.random_pill() for x in range(3)]
            self.selected_pill = None
            self.pill_direction = 0
            return True
        else:
            return False

    def rotate_pill(self):
        try:
            self.pill_direction += 1
            pill_shapes[self.pills[self.selected_pill]][self.pill_direction]
        except IndexError:
            self.pill_direction = 0

    def drop_pill(self, cx, cy):
        # make sure that the pill isn't hanging off an edge:
        gray = False
        for (x, y) in pill_shapes[self.pills[self.selected_pill]][self.pill_direction]:
            if cx+x < 0 or cy+y < 0: break                
            try:
                if self.cells[cx+x][cy+y] == 3:
                    break
            except IndexError:
                break
        else:
            # the pill isn't hanging off an edge...kill those cooties!
            score = 0
            elim = []
            elim2 = []
            for (x, y) in pill_shapes[self.pills[self.selected_pill]][self.pill_direction]:
                elim.extend([self.cells[cx+x][cy+y]])
                self.cells[cx+x][cy+y] = None
                elim2.append((cx+x, cy+y))
            score += len(elim)
            unique = []
            for x in elim:
                if not x in unique:
                    unique.append(x)
            if len(unique) == 1:
                # they killed only one kind of cootie--bonus time!
                bonus = True
                # remove any adjacent gray cooties:
                for (x, y) in elim2:
                    self.kill_adjacent_gray(x, y)
            else:
                bonus = False
                self.spread_gray_cooties()
                # give them a gray cootie to teach them a lesson:
                try:
                    for gx in range(10):
                        for gy in range(15):
                            if self.cells[gx][gy] == None:
                                self.cells[gx][gy] = 3
                                raise UglyHack
                except:
                    pass
            self.cells = [[cell for cell in row if cell!=None] for row in self.cells]
            # replace destroyed cooties:
            for i in range(len(self.cells)):
                while len(self.cells[i]) < 15:
                    self.cells[i] = [random.choice(range(3))] + self.cells[i]
            self.turns += 1
            return score, bonus
        return False, False

    def gray_adjacent(self, x, y):
        adj = False
        if x > 0 and self.cells[x-1][y] == 3: adj = True
        if x < 9 and self.cells[x+1][y] == 3: adj = True
        if y > 0 and self.cells[x][y-1] == 3: adj = True
        if y < 14 and self.cells[x][y+1] == 3: adj = True
        return adj

    def spread_gray_cooties(self):
        spread_to = []
        for x in range(10):
            for y in range(15):
                if self.gray_adjacent(x, y):
                    spread_to.append((x,y))
        for (x, y) in spread_to:
            self.cells[x][y] = 3

    def kill_adjacent_gray(self, x, y):
        if x > 0 and self.cells[x-1][y] == 3: self.cells[x-1][y] = None
        if x < 9 and self.cells[x+1][y] == 3: self.cells[x+1][y] = None
        if y > 0 and self.cells[x][y-1] == 3: self.cells[x][y-1] = None
        if y < 14 and self.cells[x][y+1] == 3: self.cells[x][y+1] = None

    def can_place_pill(self, pill):
        "return true if there is any legal spot to drop the pill"
        try:
            for r in pill_shapes[pill]:
                for x in range(10):
                    for y in range(15):
                        legal = True
                        for (dx, dy) in r:
                            if x+dx<0 or x+dx>9:
                                legal = False
                            elif y+dy<0 or y+dy>14:
                                legal = False
                            elif self.cells[x+dx][y+dy] == 3:
                                legal = False
                        if legal:
                            raise UglyHack
        except UglyHack:
            return True
        return False

##----------------------------------------------------------------------------

# Pill Shape Data:
# Triangle:
ps0_0 = ((0,0), (-1,0), (1,0), (0,-1))
ps0_1 = ((0,0), (-1,0), (0,-1), (0,1))
ps0_2 = ((0,0), (0,1), (-1,0), (1,0))
ps0_3 = ((0,0), (1,0), (0,-1), (0,1))
# 2x3:
ps1_0 = ((-1,0), (0,0), (1,0), (-1,1), (0,1), (1,1))
ps1_1 = ((0,-1), (0,0), (0,1), (1,-1), (1,0), (1,1))
# Square:
ps2_0 = ((0,0), (1,0), (0,1), (1,1))
# Plus:
ps3_0 = ((0,0), (-1,0), (1,0), (0,-1), (0,1))

pill_shapes = ((ps0_0, ps0_1, ps0_2, ps0_3), (ps1_0, ps1_1), (ps2_0,), (ps3_0,))

