import cooties_engine
import pygame
from pygame import Rect
import random

class CootieException(Exception): pass
class GameExit(CootieException): pass
class GameOver(CootieException): pass
class NastyHack(CootieException): pass

class SoundBag(object):
    def delayed_init(self):
        self.shakes = []
        for d in range(4):
            fn = "sounds/shake_%sa.wav" % d
            self.shakes.append(pygame.mixer.Sound(fn))
        self.bloop = pygame.mixer.Sound('sounds/bloop.wav')
        self.thoom = pygame.mixer.Sound('sounds/thoom.wav')
        self.shish = pygame.mixer.Sound('sounds/shish.wav')
        self.bzzt = pygame.mixer.Sound('sounds/error.wav')

class ImageBag(object):
    def delayed_init(self):
        self.red_images = []
        for d in range(4):
            fn = "images/red_cootie_%s.png" % d
            self.red_images.append(pygame.image.load(fn).convert())
        self.blue_images = []
        for d in range(4):
            fn = "images/blue_cootie_%s.png" % d
            self.blue_images.append(pygame.image.load(fn).convert())
        self.green_images = []
        for d in range(4):
            fn = "images/green_cootie_%s.png" % d
            self.green_images.append(pygame.image.load(fn).convert())
        self.gray_images = []
        for d in range(3):
            fn = "images/gray_cootie_%s.png" % d
            self.gray_images.append(pygame.image.load(fn).convert())
        self.title = pygame.image.load('images/title.png').convert()
        self.title_large = pygame.image.load('images/title_large.png').convert()
        self.digits = pygame.image.load('images/digits.png').convert()
        self.beaker = pygame.image.load('images/beaker.png').convert()
        self.bottle = [pygame.image.load('images/bottle_0.png').convert(),
                       pygame.image.load('images/bottle_1.png').convert()]
        self.score = pygame.image.load('images/score.png').convert()
        self.combo = pygame.image.load('images/combo.png').convert()
        self.pills = [pygame.image.load('images/pill_triangle.png').convert(),
                      pygame.image.load('images/pill_2x3.png').convert(),
                      pygame.image.load('images/pill_square.png').convert(),
                      pygame.image.load('images/pill_diamond.png').convert()]
        self.pill_cursor = pygame.image.load('images/pill_select.png').convert()
        self.pill_cursor.set_colorkey((255, 255, 255), pygame.RLEACCEL)
        self.square = pygame.image.load('images/square.png').convert()
        self.square.set_colorkey((255, 255, 255), pygame.RLEACCEL)
        self.cursor = pygame.image.load('images/hand_cursor.png').convert()
        self.cursor.set_colorkey((255, 255, 255), pygame.RLEACCEL)
        self.game_over = pygame.image.load('images/gameover.png').convert()
        self.game_over.set_colorkey((255, 0, 255), pygame.RLEACCEL)
        self.new_hs = pygame.image.load('images/new_hs.png').convert()
        self.menu_play = [pygame.image.load('images/menu_play_0.png').convert(),
                          pygame.image.load('images/menu_play_1.png').convert()]
        self.menu_help = [pygame.image.load('images/menu_help_0.png').convert(),
                          pygame.image.load('images/menu_help_1.png').convert()]
        self.menu_quit = [pygame.image.load('images/menu_quit_0.png').convert(),
                          pygame.image.load('images/menu_quit_1.png').convert()]
        self.help = [pygame.image.load('images/help_1.png').convert(),
                     pygame.image.load('images/help_2.png').convert(),
                     pygame.image.load('images/help_3.png').convert()]
        self.bio = [pygame.image.load('images/bio_0.png').convert(),
                    pygame.image.load('images/bio_1.png').convert(),
                    pygame.image.load('images/bio_2.png').convert(),
                    pygame.image.load('images/bio_3.png').convert(),
                    pygame.image.load('images/bio_4.png').convert()]
        self.hiscore = pygame.image.load('images/hiscore.png').convert()
        self.hiscore.set_colorkey((255, 0, 255), pygame.RLEACCEL)
        self.bio_num = 0;
        self.background = pygame.Surface(screen_size)
        self.background.fill((255, 255, 255))
        self.cursor_save = pygame.Surface(self.cursor.get_size())

        self.red_frames = [1, 1, 1, 0, 0, 1, 1, 1, 2, 2, 2, 2]
        self.blue_frames = [0, 1, 2, 1]
        self.green_frames = [0, 0, 1, 2, 2, 1]
        self.gray_frames = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1]

        self.scared = [self.red_images[3],
                       self.blue_images[3],
                       self.green_images[3],
                       self.gray_images[0]]

        self.red_delay = 1
        self.blue_delay = 9
        self.green_delay = 7
        self.gray_delay = 3

        self.ticks = 0
        
    def update(self):
        self.ticks += 1
        red_index = (self.ticks / self.red_delay) % len(self.red_frames)
        self.red_cootie = self.red_images[self.red_frames[red_index]]
        blue_index = (self.ticks / self.blue_delay) % len(self.blue_frames)
        self.blue_cootie = self.blue_images[self.blue_frames[blue_index]]
        green_index = (self.ticks / self.green_delay) % len(self.green_frames)
        self.green_cootie = self.green_images[self.green_frames[green_index]]
        gray_index = (self.ticks / self.gray_delay) % len(self.gray_frames)
        self.gray_cootie = self.gray_images[self.gray_frames[gray_index]]

    def current_frame(self, kind):
        return (self.red_cootie, self.blue_cootie,
                self.green_cootie, self.gray_cootie)[kind]

    def get_bio(self):
        i = self.bio[self.bio_num]
        self.bio_num = (self.bio_num+1) % len(self.bio)
        return i
        

def blit_digit(digit, position):
    sr = Rect((40 * (digit % 5), 60 * (digit / 5)), (40, 60))              
    screen.blit(img.digits, position, sr)

def blit_number(number, position):
    (x, y) = position
    for digit in str(number):
        blit_digit(ord(digit)-48, (x, y))
        x += 40

def test_display():
    screen.blit(img.background, (0, 0))
    screen.blit(img.beaker, (0, 0))
    screen.blit(img.title, (440, 0))
    cooties = (img.red_cootie, img.blue_cootie, img.green_cootie, img.gray_cootie)
    for row in range(15):
        for col in range(10):
            screen.blit(random.choice(cooties), (col*36+33, row*30+4))
    screen.blit(img.bottle[0], (440, 160))
    screen.blit(img.score, (0, 500))
#    blit_number(8675309, (168, 500))
    screen.blit(img.combo, (500, 500))
#    blit_number(8, (720, 500))
    pygame.display.update()

class Board(cooties_engine.Board):
    def __init__(self):
        cooties_engine.Board.__init__(self)
        self.position = (33, 4)
        self.bottle_area = Rect((440, 160), img.bottle[0].get_size())
        self.pill_area = Rect((460, 380), (250, 70))
        self.board_area = Rect(self.position, (360, 450))

    def _blit_cootie(self, cootie, position):
        cooties = (img.red_cootie, img.blue_cootie, img.green_cootie, img.gray_cootie)
        return screen.blit(cooties[cootie], position)

    def draw_pills(self):
        screen.blit(img.background, board.pill_area.inflate(20, 20),
                             board.pill_area.inflate(20, 20))
        for x in range(3):
            if self.pills[x] != None:
                screen.blit(img.pills[self.pills[x]], (460+90*x, 380))

    def shake_bottle(self):
        if cooties_engine.Board.shake_bottle(self):
            random.choice(snd.shakes).play()
            self.draw_pills()
            update = screen.blit(img.bottle[1], (440, 160))
            pygame.display.update(update)
            pygame.time.delay(500)
            update = screen.blit(img.bottle[0], (440, 160))
            pygame.display.update(update)
            # check for game-over condition:
            over = True
            for p in [pill for pill in self.pills if pill != None]:
                if self.can_place_pill(p):
                    over = False
            if over:
                raise GameOver
            
        
    def draw_all(self):
        "draw entire board"
        screen.blit(img.beaker, (0, 0))
        for col in range(len(self.cells)):
            for row in range(len(self.cells[col])):
                self._blit_cootie(self.cells[col][row],
                                  (self.position[0] + 36 * col,
                                   self.position[1] + 30 * row))

    def draw_pill_cursor(self):
            screen.blit(img.pill_cursor, (450 + self.selected_pill * 90, 370))

    def draw_piece_cursor(self, mpos):
        if self.selected_pill != None:
            mx, my = mpos
            my -= 2
            cx = (mx - self.position[0]) / 36
            cy = (my - self.position[1]) / 30
            for (x, y) in cooties_engine.pill_shapes[self.pills[self.selected_pill]][self.pill_direction]:
                if cx+x < 0 or cy+y < 0: break                
                try:
                    self.cells[cx+x][cy+y]
                except IndexError:
                    break
            else:
                for (x, y) in cooties_engine.pill_shapes[self.pills[self.selected_pill]][self.pill_direction]:
                    screen.blit(img.scared[self.cells[cx+x][cy+y]],
                                           (self.position[0]+36*(cx+x),
                                            self.position[1]+30*(cy+y)))
                    screen.blit(img.square, ((cx + x) * 36 + self.position[0] - 1,
                                                 (cy + y) * 30 + self.position[1] - 1))
    def drop_pill(self, cx, cy):
        global score
        global combo
        (result, bonus) = cooties_engine.Board.drop_pill(self, cx, cy)
        if result != False:
            if bonus:
                combo += 1
                snd.bloop.play()
            else:
                combo = 1
                snd.thoom.play()
            score += result * combo
            for (x, y) in cooties_engine.pill_shapes[self.pills[self.selected_pill]][self.pill_direction]:
                screen.blit(img.background, (self.position[0]+36*(cx+x), self.position[1]+30*(cy+y)),
                            ((self.position[0]+36*(cx+x), self.position[1]+30*(cy+y)),(36,30)))
            self.pills[self.selected_pill] = None
            self.selected_pill = None
            self.pill_direction = 0
            self.draw_pills()
            pygame.display.update()
            pygame.time.delay(500)
            # check for game-over condition:
            if self.pills != [None, None, None]:
                over = True
                for p in [pill for pill in self.pills if pill != None]:
                    if self.can_place_pill(p):
                        over = False
                if over:
                    raise GameOver
        else:
            snd.bzzt.play()
        

def draw_mouse():
    mpos = pygame.mouse.get_pos()
    img.cursor_save.blit(screen, (0, 0), (mpos, (36, 49)))
    pygame.display.update(screen.blit(img.cursor, mpos))
    screen.blit(img.cursor_save, mpos)

def handle_click(ev):
    if (ev.button == 1):
        # Left button:
        if board.bottle_area.collidepoint(ev.pos):
            board.shake_bottle()
        if board.pill_area.collidepoint(ev.pos):
            old = board.selected_pill
            board.selected_pill = (ev.pos[0] - 450) / 90
            if board.pills[board.selected_pill] == None:
                board.selected_pill = old
                return False
            if board.selected_pill != old:
                snd.shish.play()
            board.draw_pills()
            board.draw_pill_cursor()
        if board.board_area.collidepoint(ev.pos):
            if board.selected_pill == None:
                return False
            cx = (ev.pos[0] - board.position[0]) / 36
            cy = (ev.pos[1] - 2 - board.position[1]) / 30
            board.drop_pill(cx, cy)
    elif (ev.button == 3):
        # Right button:
        if board.board_area.collidepoint(ev.pos):
            if board.selected_pill != None and board.pills[board.selected_pill] != None:
                snd.shish.play()
                board.rotate_pill()

def play_one_game():
    global screen
    global board
    global clock
    global score
    global combo
    test_display()
    board = Board()
    old_score = -1
    old_combo = -1
    score = 0
    combo = 1
    board.draw_all()
    screen.blit(img.hiscore, (125, 100))
    hs = get_hiscore()
    blit_number(hs, (400 - 20 * len(str(hs)), 300))
    pygame.display.update()
    wait_for_mouse(3000)
    test_display()
    try:
        while True:
            img.update()
            screen_updates = []
            for ev in pygame.event.get():
                if ev.type == pygame.QUIT:
                    raise GameExit
                elif ev.type == pygame.KEYDOWN:
                    if ev.key == 27:
                        raise GameOver
                elif ev.type == pygame.MOUSEBUTTONDOWN:
                    handle_click(ev)
            board.draw_all()
            (mx, my) = pygame.mouse.get_pos()
            if board.board_area.collidepoint(mx, my):
                board.draw_piece_cursor((mx, my))
            if score != old_score:
                blit_number(score, (168, 500))
                old_score = score
            if combo != old_combo:
                screen.blit(img.background, (720, 500))
                blit_number(combo, (720, 500))
                old_combo = combo
            pygame.display.update()
            clock.tick(20)
    except GameOver:
        board.draw_all()
        blit_number(score, (168, 500))
        game_over_screen()

def game_over_screen():
    hs = get_hiscore()
    screen.blit(img.game_over, (100, 100))
    pos = (400 - 20 * len(str(score)), 324)
    blit_number(score, pos)
    if score > hs:
        set_hiscore(score)
        screen.blit(img.new_hs, (250, 400))
    pygame.display.update()
    wait_for_mouse(0)

def wait_for_mouse(ms):
    time = pygame.time.get_ticks()
    try:
        while True:
            if pygame.time.get_ticks() - time > ms:
                if ms > 0:
                    raise NastyHack
            for ev in pygame.event.get():
                if ev.type == pygame.MOUSEBUTTONDOWN:
                    raise NastyHack()
                if ev.type == pygame.KEYDOWN:
                    raise NastyHack()
    except NastyHack: pass



def help_screen():
    for n in range(3):
        screen.blit(img.help[n], (0,0))
        pygame.display.update()
        wait_for_mouse(0)


def bio_screen():
    screen.blit(img.get_bio(), (0,0))
    pygame.display.update()
    wait_for_mouse(8000)

def main_menu():
    time = pygame.time.get_ticks()
    try:
        while True:
            if pygame.time.get_ticks() - time > 5000:
                bio_screen()
                time = pygame.time.get_ticks()
            screen.blit(img.background, (0,0))
            screen.blit(img.title_large, (150,20))
            for ev in pygame.event.get():
                if ev.type == pygame.MOUSEBUTTONDOWN:
                    if Rect((300, 260), img.menu_play[0].get_size()).collidepoint(pos):
                        action = "play"
                        raise NastyHack()
                    elif Rect((300, 360), img.menu_help[0].get_size()).collidepoint(pos):
                        help_screen()
                        time = pygame.time.get_ticks()
                    elif Rect((300, 460), img.menu_quit[0].get_size()).collidepoint(pos):
                        raise GameExit()
                if ev.type == pygame.KEYDOWN:
                    if ev.key == 27:
                        raise GameExit()
            pos = pygame.mouse.get_pos()
            if Rect((300, 260), img.menu_play[0].get_size()).collidepoint(pos):
                screen.blit(img.menu_play[1], (290, 260))
            else:
                screen.blit(img.menu_play[0], (300, 260))
            if Rect((300, 360), img.menu_help[0].get_size()).collidepoint(pos):
                screen.blit(img.menu_help[1], (300, 360))
            else:
                screen.blit(img.menu_help[0], (300, 360))
            if Rect((300, 460), img.menu_quit[0].get_size()).collidepoint(pos):
                screen.blit(img.menu_quit[1], (300, 460))
            else:
                screen.blit(img.menu_quit[0], (300, 460))
            pygame.display.update()
            clock.tick(20)
    except NastyHack:
        pass

def main():
    global screen
    global board
    global clock
    try:
        try:
            pygame.mixer.pre_init(22050, 16, False)
            pygame.init()
            screen = pygame.display.set_mode(screen_size)
            img.delayed_init()
            snd.delayed_init()
            img.update()
            clock = pygame.time.Clock()
            pygame.display.set_caption("You've Got COOTIES!")
            while True:
                main_menu()
                play_one_game()
        except GameExit:
            pass
    finally:
        pygame.quit()

def get_hiscore():
    try:
        f = open('cooties.hs', 'r')
        s = f.readline()
        f.close()
    except IOError:
        set_hiscore(0)
        return 0
    return int(s)

def set_hiscore(sc):
    f = open('cooties.hs', 'w')
    f.write("%s\n" % sc)
    f.close()
    
## ---------------------------------------------------------------------------

# Define some global names:
img = ImageBag()
snd = SoundBag()
screen = None
clock = None
screen_size = (800, 600)
score = 0
combo = 1

if __name__ == '__main__':
    main()