
from OpenGL.GL import *
from OpenGL.GLU import *
import random
from renderer import renderer

__all__ = [
    "SheepModel",
    "FarmerModel",
    "FarmerModel2",
    "GroundModel",
    "WoodWallModel",
    "MetalWallModel",
    "BrokenWallModel",
    "CannonModel",
    "CannonBallModel",
    "ExplosionModel",
    ]

def draw_cube():
    glBegin(GL_QUADS)
    glNormal3f(-1,0,0)
    glVertex3f(-1,0,-1)
    glVertex3f(-1,2,-1)
    glVertex3f(-1,2,1)
    glVertex3f(-1,0,1)
    
    glNormal3f(1,0,0)
    glVertex3f(1,0,-1)
    glVertex3f(1,2,-1)
    glVertex3f(1,2,1)
    glVertex3f(1,0,1)

    glNormal3f(0,0,-1)
    glVertex3f(-1,0,-1)
    glVertex3f(-1,2,-1)
    glVertex3f(1,2,-1)
    glVertex3f(1,0,-1)

    glNormal3f(0,0,1)
    glVertex3f(-1,0,1)
    glVertex3f(-1,2,1)
    glVertex3f(1,2,1)
    glVertex3f(1,0,1)

    glNormal(0,1,0)
    glVertex(-1,2,-1)
    glVertex(1,2,-1)
    glVertex(1,2,1)
    glVertex(-1,2,1)
    glEnd()
    

class _singleton(type):
    def __init__(cls, name, bases, dict):
        type.__init__(cls, name, bases, dict)
        cls._instance = None

class Singleton(object):
    __metaclass__ = _singleton
    
    def __new__(cls):
        if cls._instance is None:
            cls._instance = object.__new__(cls)
        return cls._instance

class Model(Singleton):
    quadric = gluNewQuadric() ## need one for every instance?
    
    def draw(self): raise NotImplemented

    def draw_cached(self):
        if not hasattr(self, "_listid"):
            id = self._listid = glGenLists(1)
            glNewList(id, GL_COMPILE_AND_EXECUTE)
            self.draw()
            glEndList()
        else:
            glCallList(self._listid)
    
class SheepModel(Model):
    def draw(self):
        glMaterial(GL_FRONT_AND_BACK, GL_AMBIENT, (1,1,1))
        glMaterial(GL_FRONT_AND_BACK, GL_DIFFUSE, (1,1,1))
        #gluQuadricTexture(self.quadric, GL_TRUE)
        #glBindTexture(GL_TEXTURE_2D, renderer.wool_tex)
        #glEnable(GL_TEXTURE_2D)
        glPushMatrix()
        glScale(1,1,1.3)
        gluSphere(self.quadric, 1.0, 8,8)
        glPopMatrix()
        #glBindTexture(GL_TEXTURE_2D,0)
        #glDisable(GL_TEXTURE_2D)
        gluQuadricTexture(self.quadric, GL_FALSE)
        glPushMatrix()
        glTranslatef(0,.7,1.2)
        glRotatef(30,1,0,0)
        glScale(.9,.7,1.5)
        gluSphere(self.quadric, 0.5, 5, 5)
        glPopMatrix()
        glTranslatef(0,.1, -1.2)
        gluSphere(self.quadric, 0.4, 3, 3)        

class FarmerModel(Model):
    shirt_color = (.8,0,0)
    
    def draw(self):
        glMaterial(GL_FRONT_AND_BACK, GL_AMBIENT, (.96,.73,.65))
        glMaterial(GL_FRONT_AND_BACK, GL_DIFFUSE, (.96,.73,.65))
        glPushMatrix()
        glTranslatef(0,1,0)
        gluSphere(self.quadric, 0.7, 8,8)
        glTranslatef(0,0,0.3)
        glScalef(1,1,3)
        gluSphere(self.quadric, 0.3, 6,6)
        glPopMatrix()
        glMaterial(GL_FRONT_AND_BACK, GL_AMBIENT, (self.shirt_color,0,0))
        glMaterial(GL_FRONT_AND_BACK, GL_DIFFUSE, (self.shirt_color,0,0))
        glScalef(2,.5,1)
        gluSphere(self.quadric, 0.6, 8,8)

class FarmerModel2(FarmerModel):
    shirt_color = (0,0,.8)

class GroundModel(Model):
    def draw(self):
##        glMaterial(GL_FRONT_AND_BACK, GL_AMBIENT, (0,1,0))
##        glMaterial(GL_FRONT_AND_BACK, GL_DIFFUSE, (0,1,0))
        glMaterial(GL_FRONT_AND_BACK, GL_AMBIENT, (1.5,1.5,1.5))
        glMaterial(GL_FRONT_AND_BACK, GL_DIFFUSE, (1,1,1))
        glBindTexture(GL_TEXTURE_2D, renderer.ground_tex)
        glEnable(GL_TEXTURE_2D)
        glBegin(GL_QUADS)
        for x in range(-5,5):
            xx = x+1
            for y in range(-3,3):
                yy = y + 1
                glNormal3f(0,1,0)
                glTexCoord2f(0.1,0.1);glVertex3f(x*5,0,y*5)
                glTexCoord2f(0.9,0.1);glVertex3f(xx*5,0,y*5)
                glTexCoord2f(0.9,0.9);glVertex3f(xx*5,0,yy*5)
                glTexCoord2f(0.1,0.9);glVertex3f(x*5,0,yy*5)
        glEnd()
        glDisable(GL_TEXTURE_2D)
        glBindTexture(GL_TEXTURE_2D,0)
        
class WallModel(Model):
    
    def draw_with(self, tex, tex2):
        #glMaterial(GL_FRONT_AND_BACK, GL_AMBIENT, (.84,.6,.06))
        #glMaterial(GL_FRONT_AND_BACK, GL_DIFFUSE, (.84,.6,.06))
        glMaterial(GL_FRONT_AND_BACK, GL_AMBIENT, (1,1,1))
        glMaterial(GL_FRONT_AND_BACK, GL_DIFFUSE, (1,1,1))
        glEnable(GL_TEXTURE_2D)

        glBindTexture(GL_TEXTURE_2D, tex)
        glBegin(GL_QUADS)
        glNormal3f(0,1,0)
        glTexCoord2f(0,0); glVertex3f(-1,2,-1)
        glTexCoord2f(1,0); glVertex3f(1,2,-1)
        glTexCoord2f(1,1); glVertex3f(1,2,1)
        glTexCoord2f(0,1); glVertex3f(-1,2,1)
        glEnd()

        glBindTexture(GL_TEXTURE_2D, tex2)
        glBegin(GL_QUADS)
        glNormal3f(0,0,1)
        glTexCoord2f(0,0); glVertex3f(-1,2,1)
        glTexCoord2f(1,0); glVertex3f(1,2,1)
        glTexCoord2f(1,1); glVertex3f(1,0,1)
        glTexCoord2f(0,1); glVertex3f(-1,0,1)

        glTexCoord2f(0,0); glNormal3f(1,0,0)
        glTexCoord2f(0,0); glVertex3f(1,2,1)
        glTexCoord2f(1,0); glVertex3f(1,2,-1)
        glTexCoord2f(1,1); glVertex3f(1,0,-1)
        glTexCoord2f(0,1); glVertex3f(1,0,1)

        glNormal3f(0,0,-1)
        glTexCoord2f(0,0); glVertex3f(1,2,-1)
        glTexCoord2f(1,0); glVertex3f(-1,2,-1)
        glTexCoord2f(1,1); glVertex3f(-1,0,-1)
        glTexCoord2f(0,1); glVertex3f(1,0,-1)

        glNormal3f(-1,0,0)
        glTexCoord2f(0,0); glVertex3f(-1,2,-1)
        glTexCoord2f(1,0); glVertex3f(-1,2,1)
        glTexCoord2f(1,1); glVertex3f(-1,0,1)
        glTexCoord2f(0,1); glVertex3f(-1,0,-1)

        glEnd()
        glBindTexture(GL_TEXTURE_2D,0)
        glDisable(GL_TEXTURE_2D)

class WoodWallModel(WallModel):
    def draw(self):
        self.draw_with(renderer.wood_tex,renderer.wood_tex2)

class MetalWallModel(WallModel):
    def draw(self):
        self.draw_with(renderer.metal_tex,renderer.metal_tex)

class BrokenWallModel(Model):
    def draw(self):
        glDisable(GL_LIGHTING)
        glColor3f(.1,.1,.1)
        glBegin(GL_QUADS)
        glNormal3f(0,1,0)
        glTexCoord2f(0,0); glVertex3f(-1,.01,-1)
        glTexCoord2f(1,0); glVertex3f(1,.01,-1)
        glTexCoord2f(1,1); glVertex3f(1,.01,1)
        glTexCoord2f(0,1); glVertex3f(-1,.01,1)
        glEnd()
        glEnable(GL_LIGHTING)
        

class CannonModel(Model):
    def draw(self):
        glMaterial(GL_FRONT_AND_BACK, GL_AMBIENT, (.8,.8,.8))
        glMaterial(GL_FRONT_AND_BACK, GL_DIFFUSE, (.8,.8,.8))
        h = 1
        l = 2.5
        glBegin(GL_QUADS)
        glNormal3f(-1,0,0)
        glVertex3f(-1,0,-1)
        glVertex3f(-1,h,-1)
        glVertex3f(-1,h,1)
        glVertex3f(-1,0,1)
        
        glNormal3f(1,0,0)
        glVertex3f(1,0,-1)
        glVertex3f(1,h,-1)
        glVertex3f(1,h,1)
        glVertex3f(1,0,1)

        glNormal3f(0,0,-1)
        glVertex3f(-1,0,-1)
        glVertex3f(-1,h,-1)
        glVertex3f(1,h,-1)
        glVertex3f(1,0,-1)

        glNormal3f(0,0,1)
        glVertex3f(-1,0,1)
        glVertex3f(-1,h,1)
        glVertex3f(1,h,1)
        glVertex3f(1,0,1)

        glNormal(0,1,0)
        glVertex(-1,h,-1)
        glVertex(1,h,-1)
        glVertex(1,h,1)
        glVertex(-1,h,1)
        glEnd()
        glTranslate(0,h,0)
        gluSphere(self.quadric, 0.8, 12,12)
        ## TODO: rotatable turret
        #glRotate(90,0,1,0)
        glRotate(-40,1,0,0)
        gluCylinder(self.quadric, 0.3,0.3,l,6,3)

class CannonBallModel(Model):
    def draw(self):
        glMaterial(GL_FRONT_AND_BACK, GL_AMBIENT, (.2,.2,.2))
        glMaterial(GL_FRONT_AND_BACK, GL_DIFFUSE, (.2,.2,.2))
        gluSphere(self.quadric, 0.3, 8,8)


class ExplosionModel(object):
    quadric = gluNewQuadric() ## need one for every instance?

    def __init__(self):
        self.life = 0

    def draw(self):
        size = self.life * 0.02 + 0.01
        glDisable(GL_LIGHTING)
        glEnable(GL_BLEND)
        glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)
        r = max(0,3.0 - self.life * 0.01)
        g = max(0,3.0 - self.life * 0.02)
        b = max(0,3.0 - self.life * 0.03)
        a = max(0,2.0 - self.life * 0.04)
        glColor4f(r,g,b,a)
        gluSphere(self.quadric, size, 16,16)
        #glScale(1.5,0.1,1.5)
        glRotate(90,1,0,0)
        gluDisk(self.quadric, size*1.5+0.2, size*1.6+0.5, 16,16)
        glDisable(GL_BLEND)
        glEnable(GL_LIGHTING)

    draw_cached = draw

class GhostModel(Model):
    def draw(self):
        glEnable(GL_BLEND)
        glBlendFunc(GL_CONSTANT_ALPHA, GL_ONE_MINUS_CONSTANT_ALPHA)
        #glBlendColor(
        self._structure.draw()

class StructureGhost(_singleton):
    def __init__(self, cls):
        _singleton.__init__("StructureGhost[%s]" % cls.__name__, [GhostModel], {'_structure':cls()})
        
