
from renderer import renderer

from math import sin,cos,pi,atan

class Entity(object):
    def __init__(self, model_cls):
        self.model = model_cls()
        self.x = 0
        self.y = 0
        self.z = 0
        self.rot = 0
        self.active = 0
        self.scale = 1.0

    def set_xyz(self,x,y,z):
        self.x=x
        self.y=y
        self.z=z

    def move(self,dx,dy,dz):
        self.x += dx
        self.y += dy
        self.x += dz

    def forward(self, d):
        r = pi * (self.rot+180) / 180.0
        self.x -= sin(r) * d
        self.z -= cos(r) * d

    def forward_xz(self,d):
        r = pi * (self.rot+180) / 180.0
        fx = self.x - sin(r) * d
        fz = self.z - cos(r) * d
        return fx,fz
        

    def rotate(self, rot):
        self.rot += rot

    def heading(self,x,z):
        dx = self.x-x
        dz = self.z-z
        if dx == 0:
            if dz < 0:
                return 0
            return 180
        d = dz/abs(dx)
        ## kludgy but works
        if dx > 0:
            d = -d
        r =  atan(d)*180.0/pi
        if dx < 0:
            r += 90
        else:
            r -= 90
        return r

    def face(self,x,z):
        self.rot = self.heading(x,z)

    def draw(self, cached=1):
        if not self.active:
            return
        renderer.draw_model(self.model, (self.x,self.y,self.z), self.rot, self.scale, cached)
