import pygame, random
import gfx, ticker, sheep


images = ['star', 'dog', 'stick', 'flag', 'mark', 'sheperd_tile',
    	  'sheperd1_good', 'sheperd1_ok', 'sheperd1_bad']

sounds = ['ok1', 'ok2', 'ok3', 'ok4' ]

	  
sheperd1_palette = [(255,0,255),    #colorkey
    	    	    (255,0,0),	    #coat
		    (250,50,50),    #shirt
		    (190,140,90),   #skin
		    (255,255,255),  #eyes
		    (130,90,25),    #iris
		    (120,100,90),   #nose
		    (200,170,60)]   #lips

cloth_colors = [((220, 10, 10), (200,50,50)),
    	        ((10, 10, 220), (50,50,200)),
    	        ((10, 220, 10), (50,200,50)),

    	       # ((220, 220, 10), (200,200,50)),
    	        ((10, 220, 220), (50,200,200)),
    	        ((220, 10, 220), (200,50,200)),

    	       # ((220, 220, 220), (200,200,200)),

    	    	((150, 10, 10), (100,30,30)),
    	        ((10, 10, 150), (30,30,100)),
    	        ((10, 150, 10), (30,100,30)),

    	        ((150, 150, 10), (100,100,30)),
    	        ((10, 150, 150), (30,100,200)),
    	        ((150, 10, 150), (100,30,200)),

    	        ((150, 150, 150), (100,100,100)),

	       ]
orig_colors = cloth_colors[:] #save since we destroy the list

all_names = ['Jacob', 'Peleg', 'Serug', 'Shelah', 'Shem',
    	     'Gether', 'Arphaxad', 'Cush', 'Raamah', 'Sabteca',
	     'Mizraim', 'Seba', 'Havila', 'Jared', 'Kenan', 'Enosh',
	     'Mahalalel', 'Lamech', 'Seth', 'Isaac', 'Abram']
orig_names = all_names[:] #save since we destroy the list

class Sheperd:
    def __init__(self, house):
    	global all_names, cloth_colors
    	self.house = house
	self.village = house.village

    	if not cloth_colors:
	    cloth_colors = orig_colors[:]
	if not all_names:
	    all_names = orig_names[:]

    	self.name = random.choice(all_names)
	all_names.remove(self.name)
    	cloth = random.choice(cloth_colors)
	cloth_colors.remove(cloth)
	self.coatcolor, self.shirtcolor = cloth
	self.create_images()
    
    	self.numdogs = 0
	self.numcrafts = 0
    	self.skill = 0.0
	self.birthtime = 0.0
	self.anger = 0.0

    	self.pos = self.house.rect.midbottom
	self.walkto = self.pos
	self.walkticker = None
	self.rect = gfx.position(self.img.tile, center=self.pos)



    def update(self, time):
    	btime = 8.0 - (self.numcrafts * .5)
	if self.birthtime > btime:
	    self.birthtime -= btime
	    s = sheep.Sheep()
	    s.sheperd = self
	    self.village.sheep.append(sheep.Sheep())
	    sheep.sound()
    	
	if self.walkticker:
	    oldpos = self.pos
	    self.pos = self.walkticker.tick(time)
	    self.rect.center = self.pos
	    was_intown = self.village.rect.collidepoint(oldpos)
	    now_intown = self.village.rect.collidepoint(self.pos)
	    if was_intown and not now_intown: self.takesheep()
	    elif now_intown and not was_intown: self.returnsheep()
    	else:
	    was_intown = now_intown = self.village.rect.collidepoint(self.pos)

    	if not now_intown:
	    self.skill += .0005 * time
	    self.anger += .0017 * time
	else:
	    if self.house.upgraded:
	    	self.anger -= .006 * time
	    else:
	    	self.anger -= .0035 * time
    	    self.anger = max(self.anger, 0)


    def takesheep(self):
	avail = []
	for s in self.village.sheep:
	    if not s.sheperd:
	    	avail.append(s)

    	avail.sort(lambda a,b: cmp(a.food, b.food))
	
	numsheep = self.maxsheepskill()
	if numsheep: sheep.sound()
	for s in avail[:numsheep]:
	    s.sheperd = self
	

    def maxsheepskill(self):
    	num = 4 + int(self.skill/10.0) + self.numdogs
	bad = int(self.anger/10.0) 
	return min(num-bad, 20)

	
    def returnsheep(self):
	for s in self.village.sheep:
	    if s.sheperd is self:
	    	s.sheperd = None
	sheep.sound()


    def draw(self, screen, offset):
    	r = self.rect.move(offset)
	screen.blit(self.img.tile, r)
	if self.walkticker:
	    x = self.walkto[0] + offset[0] - 3
	    y = self.walkto[1] + offset[1] - 3
	    screen.blit(self.img.mark, (x, y))


    def walk(self, pos):
    	speed = .05 + (self.numcrafts*.01)
    	self.walkticker = ticker.TickerSpeed(speed, self.pos, pos)
	self.walkto = pos
	s = random.choice((sounds.ok1, sounds.ok2, sounds.ok3, sounds.ok4))
	s.set_volume(.4)
	s.play()
	
	



    def create_images(self):
    	class Empty: pass
    	self.img = Empty()
	def shade_icon(icon, color):
    	    icon.set_palette(((0,0,0), color))
	    icon.set_colorkey(0)
	    return gfx.optimize(icon)
	coat = self.coatcolor
	self.img.flag = shade_icon(rawimages.flag, coat)
	self.img.dog = shade_icon(rawimages.dog, coat)
	self.img.star = shade_icon(rawimages.star, coat)
	self.img.stick = shade_icon(rawimages.stick, coat)
	self.img.mark = shade_icon(rawimages.mark, coat)
	self.img.tile = shade_icon(rawimages.sheperd_tile, coat)
	def shade_portrait(portrait, coat, shirt, skin, flip):
	    pal = list(portrait.get_palette())
	    pal[1] = coat
	    pal[2] = shirt
	    pal[3] = skin
	    portrait.set_palette(pal)
	    portrait.set_colorkey(0)
	    if flip: portrait = pygame.transform.flip(portrait, 1, 0)
	    return gfx.optimize(portrait)
	shirt = self.shirtcolor
	skin = random.randint(170,210), random.randint(120,160), random.randint(70,110)
	flip = random.randint(0, 9) % 2
	self.img.good = shade_portrait(rawimages.sheperd1_good, coat, shirt, skin, flip)
	self.img.ok = shade_portrait(rawimages.sheperd1_ok, coat, shirt, skin, flip)
	self.img.bad = shade_portrait(rawimages.sheperd1_bad, coat, shirt, skin, flip)

    	
