import pygame, random
import gfx, ticker

images = ['sheep', 'sheep_shave', 'sheep_skull', 'sheep_tile']
sounds = ['baah1', 'baah2', 'baah3', 'baah4', 'baah5', 'baah6']
colorsheep = {}


def sound():
    s = sounds.baah1, sounds.baah2, sounds.baah3, sounds.baah4, sounds.baah5, sounds.baah6
    random.choice(s).play()



done_sheep_icons = 0
def init_sheep_icons():
    global done_sheep_icons
    done_sheep_icons = 1

    mask1 = rawimages.sheep.convert(16)
    mask2 = rawimages.sheep_shave.convert(16)
    mask3 = rawimages.sheep_skull.convert(16)
    
    mask1.set_colorkey((255,255,255))
    mask2.set_colorkey((255,255,255))
    mask3.set_colorkey((255,255,255))
    colorsheep[0,0] = make_sheep_color(mask1, mask2, mask3, (255,255,255))
    colorsheep[1,0] = make_sheep_color(mask1, mask2, mask3, (255,128,128))
    colorsheep[2,0] = make_sheep_color(mask1, mask2, mask3, (255,0,0))
    colorsheep[0,1] = make_sheep_color(mask1, mask2, mask3, (128,128,255))
    colorsheep[0,2] = make_sheep_color(mask1, mask2, mask3, (0,0,225))
    colorsheep[1,1] = make_sheep_color(mask1, mask2, mask3, (255,128,255))
    colorsheep[1,2] = make_sheep_color(mask1, mask2, mask3, (128,0,255))
    colorsheep[2,1] = make_sheep_color(mask1, mask2, mask3, (255,0,128))
    colorsheep[2,2] = make_sheep_color(mask1, mask2, mask3, (255,0,255))

    images.sheep_tile2 = pygame.transform.flip(images.sheep_tile, 1, 0)
    


def make_sheep_color(mask1, mask2, mask3, color):   
    img1 = pygame.Surface(mask1.get_size())
    img1.fill(color)
    img1.blit(mask1, (0,0))
    img1.set_colorkey((0,0,0))
   
    img2 = pygame.Surface(mask2.get_size())
    img2.fill(color)
    img2.blit(mask2, (0,0))
    img2.set_colorkey((0,0,0))
    
    img3 = pygame.Surface(mask3.get_size())
    img3.fill(color)
    img3.blit(mask3, (0,0))
    img3.set_colorkey((0,0,0))

    return gfx.optimize(img1), gfx.optimize(img2), gfx.optimize(img3)
    #return img1, img2, img3


class Sheep:
    def __init__(self):
    	if not done_sheep_icons:
	    init_sheep_icons()
    
    	self.food = float(random.randint(60, 80))
	self.water = float(random.randint(60, 80))
	self.age = float(random.randint(0, 5))
	self.damage = float(random.randint(0, 5))
	self.wool = float(random.randint(0, 5))
	self.selected = 0 #for intown selecting
	self.shearing = 0.0 #for intown trims
	self.dead = 0
	self.sheperd = None

    	self.posx = float(random.randint(-30,30))
    	self.posy = float(random.randint(-30,30))
	self.image = images.sheep_tile
    	self.moveticker = None

	self.colorsheep = colorsheep
	
	
	
    def update(self, time):
    	if self.dead:
	    self.dead += time
	    return
    	if not self.sheperd: #in town
	    self.food = self.food - .0015 * time
	    if self.water < 0.0:
	    	self.water += .001 * time
	    self.water = min(self.water + .0006 * time, 100.0)
	else: #on the grass
	    if self.food < 0.0:
	    	self.food += .005 * time
	    else:
	    	self.food += .002 * time
	    self.water -= .003 * time

	self.age += .0004 * time
	if not self.shearing:
	    self.wool += .0015 * time
	if self.age > 100.0:
	    self.damage += self.age-100.0
	if self.food < 0.0:
	    self.damage -= self.food
	if self.water < 0.0:
	    self.damage -= self.water
	if self.damage > 100:
	    self.dead = 1

    	if not self.moveticker:
	    movex, movey = random.randint(-2,2), random.randint(-2,2)
	    self.posx = max(min(self.posx+movex, 40), -40)
	    self.posy = max(min(self.posy+movey, 40), -40)
	    if movex<0: self.image = images.sheep_tile2
	    elif movex>0: self.image = images.sheep_tile
	    self.moveticker = ticker.Ticker(random.randint(300,800), 0, 1)
	else:
	    self.moveticker.tick(time)


    def get_icon(self):
    	if self.dead:
    	    index = 2
	else:
	    index = self.wool < 20.0
	
    	needfood = 0
	if self.food < 0.0: needfood = 2
	elif self.food < 15.0: needfood = 1
	
	needwater = 0
	if self.water < 0.0: needwater = 2
	elif self.water < 15.0: needwater = 1
	
	return self.colorsheep[needfood, needwater][index]

    def __str__(self):
    	return '<Sheep(F=%.2f,W=%.2f,A=%.2f,D=%.2f)>'%(self.food,self.water,self.age,self.damage)
	

