import pygame

import gfx, gui, ticker, village, dialog

images = ['hammer']
sounds = ['click', 'money']


class VillageHUD:
    def __init__(self, village):
    	self.village = village
	self.backc = 30, 30, 50
	self.forec = 220, 200, 10
	
	self.gold = -1
	self.goldimage = gui.render_gold(0)
	self.goldticker = None

    	self.width = 170
	self.base = 106
	self.height = 100
	self.numsheeprows = 0
	
	self.upgrade_text = "upgrade the main corral will allow you to hold " \
	    	       "more sheep and create new buildings"
	img = pygame.transform.scale(village.town_icons[1], (20,20))
	
	icons = gui.render_gold(village.town_gold[0]), gui.images.clock_long
	tip = gui.render_tooltip("Upgrade To Ranch", icons, self.upgrade_text, self.backc, self.forec)
	self.ui_upgrade = gui.Button(img, (20, self.height+2, 50, 30), tip, self.forec, self.upgrade_pushed)

    	img = pygame.transform.scale(images.hammer, (20,20))
    	tip = gui.render_tooltip("Create New Building", None, None, self.backc, self.forec)
	self.ui_build = gui.Button(img, (100, self.height+2, 50, 30), tip, self.forec, self.build_push)
    
    	self.ui_all = [self.ui_upgrade, self.ui_build]

    
    def update(self, time):
    	if self.goldticker:
	    self.gold = self.goldticker.tick(time)
	    self.goldimage = gui.render_gold(self.gold)
    	elif self.village.gold != self.gold:
	    self.goldticker = ticker.TickerSpeed(0.01, self.gold, self.village.gold)

    	numsheeprows = max(0,len(self.village.sheep)-1) / 10 + 1
	if numsheeprows != self.numsheeprows:
	    new = numsheeprows*12 + self.base
	    self.stretchticker = ticker.Ticker(700, self.height, new, ticker.smooth)
	    self.numsheeprows = numsheeprows
	if self.stretchticker:
	    self.height = self.stretchticker.tick(time)
	    self.ui_upgrade.rect.bottom = self.height + 2
	    self.ui_build.rect.bottom = self.height + 2

    	#tricky update for the disabled upgrade button
	self.ui_upgrade.disabled &= ~1
	if self.village.gold < self.village.town_gold[self.village.townsize]:
	    self.ui_upgrade.disabled |= 1
    	self.ui_build.disabled = len(self.village.buildings) >= 11
	
    def draw(self, screen):
    	taskheight = 0
	for t in self.village.tasks:
	    taskheight += t.size
	
    	r = pygame.Rect(0, 0, self.width, self.height+taskheight+10)
	self.rect = r
	gui.fill_noncorners_buttopleft(screen, self.backc, r)
	name = self.village.town_names[self.village.townsize]
	icon = self.village.town_icons[self.village.townsize]
	tr = pygame.Rect(5, 5, self.width-10, 30)
	gui.draw_titlebar(screen, self.forec, self.backc, tr, name, icon)
    
    	screen.blit(self.goldimage, (5, 40))
	
	posx, posy = 8, 70
	for s in self.village.sheep:
	    if s.sheperd: continue
	    screen.blit(s.get_icon(), (posx, posy))
	    posx += 15
	    if posx > 150:
	    	posx = 8
		posy += 12

    	offsety = self.height + 5
	for t in self.village.tasks:
	    t.draw(screen, (5, offsety))
	    offsety += t.size

    	for ui in self.ui_all:
	    ui.draw(screen)


    def mousemoved(self, pos):
    	for ui in self.ui_all:
	    ui.mousemoved(pos)
    
    def mousepushed(self, pos):
	for ui in self.ui_all:
	    ui.mousepushed(pos)
	return self.rect.collidepoint(pos)
    
    def mousereleased(self, pos):
	for ui in self.ui_all:
	   ui.mousereleased(pos)
	return self.rect.collidepoint(pos)


	
    def upgrade_pushed(self):
    	self.ui_upgrade.disabled = 2
	time = self.village.town_time[self.village.townsize]
	tick = ticker.Ticker(time)
	task = village.TimedTask(tick, self.ui_upgrade.icon, 2, self.upgrade_finished)
	self.village.addtask(task)
	self.village.changegold(-self.village.town_gold[self.village.townsize])
	sounds.money.play()
    
    def upgrade_finished(self):
    	self.village.upgrade_town()
	if self.village.townsize != 3:
	    icon = self.village.town_icons[self.village.townsize+1]
	    title = "Upgrade To " + self.village.town_names[self.village.townsize+1]
	    gold = self.village.town_gold[self.village.townsize]
	    icons = gui.render_gold(gold), gui.images.clock_long
	    tip = gui.render_tooltip(title, icons, self.upgrade_text, self.backc, self.forec)
	    self.ui_upgrade.icon = pygame.transform.scale(icon, (20,20))
	    self.ui_upgrade.disabled_icon = gfx.ghost(self.ui_upgrade.icon)
    	    self.ui_upgrade.tooltip = tip	    
    	    self.ui_upgrade.disabled = 0

    def build_push(self):
    	village.BuildDialog(self.village)



class SheperdHUD:
    def __init__(self, village):
    	self.village = village
	self.backc = 30, 30, 50
	self.forec = 220, 200, 10
	
    	self.width = 170
	self.itemheight = 70
	#self.height = 100
	
	self.pos = gfx.res.width - self.width, 0
    	self.rect = pygame.Rect(self.pos, (self.width, 1))
	
	
    
    def update(self, time):
    	pass
	
    def draw(self, screen):
    	size = len(self.village.sheperds) * self.itemheight
	if not size: return
	
    	self.rect = pygame.Rect(self.pos, (self.width, size))
	gui.fill_noncorners_buttopleft(screen, self.backc, self.rect)

    	posx, posy = self.pos	
	
	for s in self.village.sheperds:
	    area = pygame.Rect(posx, posy, self.width, self.itemheight)
	    small = area.inflate(-10, -10)
	    
	    if s is self.village.selectsheperd:
	    	gui.outline_noncorners(screen, s.coatcolor, area.inflate(-4,-4))
	    
	    if s.anger < 20.0: pic = s.img.good
	    elif s.anger < 40.0: pic = s.img.ok
	    else: pic = s.img.bad
	    gui.draw_titlebar(screen, self.forec, self.backc, small, s.name, pic)

    	    icony = area.top + 34
	    iconx = area.left + 10
	    numstars = min(int(s.skill / 10.0), 10)
	    if numstars:
	    	for x in range(numstars):
	    	    screen.blit(s.img.star, (iconx, icony))
	    	    iconx += 7
		iconx += 6
	    if s.numdogs:
	    	for x in range(s.numdogs):
	    	    screen.blit(s.img.dog, (iconx, icony))
	    	    iconx += 7
		iconx += 6
	    if s.numcrafts:
	    	for x in range(s.numcrafts):
	    	    screen.blit(s.img.stick, (iconx, icony))
	    	    iconx += 7

	    iconx, icony = area.left + 10, area.top + 42
	    edge = area.left + 150
	    for sheep in self.village.sheep:
		if sheep.sheperd is not s: continue
		screen.blit(sheep.get_icon(), (iconx, icony))
		iconx += 15
		if iconx > edge:
	    	    iconx = area.left + 10
		    icony += 11


    	    posy += self.itemheight



    def mousemoved(self, pos):
    	pass
    
    def mousepushed(self, pos):
    	if not self.village.sheperds: return 0
    	return self.rect.collidepoint(pos)
    
    def mousereleased(self, pos):
    	if not self.village.sheperds: return 0
	if not self.rect.collidepoint(pos): return 0
	
	
	num = min(pos[1]/self.itemheight, len(self.village.sheperds)-1)
	picked = self.village.sheperds[num]
	self.village.selectsheperd = picked
	sounds.click.play()
	return 1


