

import pygame
from pygame.locals import *

import gfx, snd, data, map, ticker, gui, village, huds, sheep, playmode

images = ['question', 'clock_short']


class Scenery:
    def __init__(self, image, pos):
    	self.image = image
	self.rect = gfx.position(image, center=pos)
    def draw(self, screen, offset):
    	screen.blit(self.image, self.rect.move(offset))
    	
thegame = None

class Play:
    def __init__(self):
    	global thegame
	thegame = self
	
    	self.nextmode = None
	self.Update = self.FirstUpdate
    	self.xmove = self.ymove = 0

        self.map = map.Map()

	self.posx, self.posy = self.map.viewtile(5, 5)
    	self.village = village.Village(self.map.tilepos(5, 5))
	for x in range(7):
    	    self.village.sheep.append(sheep.Sheep())
	self.village_hud = huds.VillageHUD(self.village)
	self.sheperd_hud = huds.SheperdHUD(self.village)
	self.popup = None

    	icons = gui.render_gold(22), sheep.images.sheep, sheep.images.sheep
	desc = "Gives instant wealth and sheep. Please don't abuse, it will "\
	       "really hurt any chances of 'fun'."
    	tip = gui.render_tooltip('Cheat!', icons, desc, (30, 30, 50), (200,180,10))
    	self.button = gui.Button(gui.images.goldcoin, (180, 4, 24, 24), tip, (200,180,10))
	
	self.scenery = []
	
	self.endgameticker = 0


    def HandleEvent(self, e):   #handle an event
	if e.type == KEYDOWN:
	    if e.key == K_ESCAPE:
	    	if self.popup:
		    self.popup.close()
		    self.popup = None
	    	else:
		    self.nextmode = -1
	    elif e.key == K_LEFT: self.xmove = 8
	    elif e.key == K_RIGHT: self.xmove = -8
	    elif e.key == K_UP: self.ymove = 8
	    elif e.key == K_DOWN: self.ymove = -8
	elif e.type == KEYUP:
	    if e.key == K_LEFT or e.key == K_RIGHT:
	    	self.xmove = 0
	    elif e.key == K_UP or e.key == K_DOWN:
	    	self.ymove = 0
    	elif e.type == MOUSEMOTION:
	    if self.popup:
	    	self.popup.mousemoved(e.pos)
	    else:
	    	self.button.mousemoved(e.pos)
	    	self.village_hud.mousemoved(e.pos)
	elif e.type == MOUSEBUTTONDOWN:
	    if self.popup:
	    	if not self.popup.mousepushed(e.pos):
		    self.popup.close()
		    self.popup = None
	    else:
	    	self.button.mousepushed(e.pos)
		self.village_hud.mousepushed(e.pos)
		self.sheperd_hud.mousepushed(e.pos)
	elif e.type == MOUSEBUTTONUP:
	    if self.popup:
	    	self.popup.mousereleased(e.pos)
	    else:
		if self.button.mousereleased(e.pos):
		    self.village.changegold(22)
		    most = self.village.town_limits[self.village.townsize]
		    curr = len(self.village.sheep) 
		    for x in range(min(curr+5, most)-curr):
		        self.village.sheep.append(sheep.Sheep())
		elif self.village_hud.mousereleased(e.pos):
		    pass
		elif self.sheperd_hud.mousereleased(e.pos):
		    pass
		else:
		    p = self.posx + e.pos[0], self.posy+e.pos[1]
		    hit = 0
		    for b in self.village.buildings:
		    	if b.rect.collidepoint(p):
			    b.pressed()
			    hit = 1
		    if not hit and self.village.selectsheperd:
		    	self.village.selectsheperd.walk(p)

    def GetNextMode(self): #next mode, None=nochange, -1=quit
    	if self.nextmode:
	    global thegame
	    thegame = None
    	return self.nextmode


    def FirstUpdate(self, screen, time): #only used first draw
	self.Update = self.RealUpdate

    def RealUpdate(self, screen, time):
    	self.village.update(time)
	self.village_hud.update(time)
	self.sheperd_hud.update(time)
	if self.popup:
	    self.popup.update(time)


    	self.posx -= self.xmove
    	self.posy -= self.ymove
    	self.map.draw(screen, self.posx, self.posy)

	drawoffset = -self.posx, -self.posy
    	for s in self.scenery:
	    s.draw(screen, drawoffset)

    	
	self.village.draw(screen, drawoffset)
    	self.village_hud.draw(screen)
	self.sheperd_hud.draw(screen)
	self.button.draw(screen)
	if self.popup:
	    self.popup.draw(screen)

	
	#check for end of game
	if self.endgameticker is 0:
	    if not self.village.sheep or self.village.townsize == 3:
		self.endgameticker = ticker.Ticker(5000)
	elif self.endgameticker:
	    self.endgameticker.tick(time)
	else:
	    self.nextmode = playmode.ShowImage(self.village.townsize==3)



