#
# The tower object
#   This object is used to

# Import system stuff
import math
import pygame
from pygame.locals import *

# Import local stuff
import rs
import sheep

class Tower :

    # Constructor
    def __init__(self, x, y, orient):

        # Get the images that make up the tower.
        self.wall_l = rs.resources.AddImage('wall_l', 'wall-l.bmp',
        #                                           (0, 204, 255))
                                                   None)
        self.wall_r = rs.resources.AddImage('wall_r', 'wall-r.bmp',
        #                                           (0, 204, 255))
                                                   None)
        self.wall_n = rs.resources.AddImage('wall_n', 'wall-n.bmp',
        #                                           (0, 204, 255))
                                                   None)
        self.cren_l = rs.resources.AddImage('cren_l', 'cren-l.bmp',
        #                                           (0, 204, 255))
                                                   None)
        self.cren_r = rs.resources.AddImage('cren_r', 'cren-r.bmp',
        #                                           (0, 204, 255))
                                                   None)
        self.cren_n = rs.resources.AddImage('cren_n', 'cren-n.bmp',
        #                                           (0, 204, 255))
                                                   None)

        # Check the sizes.
        assert(self.wall_l[1].width == self.cren_l[1].width)
        assert(self.wall_r[1].width == self.cren_r[1].width)
        assert(self.wall_n[1].width == self.cren_n[1].width)
        assert(self.wall_l[1].height == self.wall_n[1].height)
        assert(self.wall_l[1].height == self.wall_r[1].height)
        assert(self.cren_l[1].height == self.cren_n[1].height)
        assert(self.cren_l[1].height == self.cren_r[1].height)

        # Store the base position of the tower.
        self.bottom = y
        self.middle = x

        # Store the current stage
        self.oldwidth     = -1
        self.oldheight    = -1
        self.oldsubwidth  = 0.0
        self.oldsubheight = 0.0
        self.width        = 0
        self.height       = 0
        self.subwidth     = 0.0
        self.subheight    = 0.0

        self.target = 0
        self.actual = 0
        self.subactual = -1.0

        self.bound = Rect(0,0,0,0)
        self.orient = orient

        self.oldstate = 0
        self.state = 0
        self.angle1 = 0.0
        self.angle2 = 0.0

        self.ctrlrad = 48
        self.ctrlrect = Rect(x - self.ctrlrad, self.ctrlrad, self.ctrlrad*2, self.ctrlrad*2)

        self.strengthrect = Rect(x - self.ctrlrad, y+32, self.ctrlrad*2, 8)
        self.oldstrength = -1.0;
        self.strength = 1.0
        
        self.powerrect = Rect(x - self.ctrlrad, y+48, self.ctrlrad*2, 8)
        self.oldpower = -1.0;
        self.power = 0.0
        
    # Draw the tower
    def Draw(self, surface) :

        list = []
        
        # If there isn't a change ...
        if ((self.width != self.oldwidth) or
            (self.height != self.oldheight) or
            (self.subwidth != self.oldsubwidth) or
            (self.subheight != self.oldsubheight)) :

            # Compute the extra partial size.
            isubwidth  = int(self.subwidth  * self.wall_n[1].width)
            isubleft   = (self.wall_n[1].width - isubwidth) / 2
            isubheight = int(self.subheight * self.wall_n[1].height)
            
            # The rectangle that contains the tower.
            self.bound.width = (self.wall_l[1].width +
                                self.wall_r[1].width + isubwidth +
                                self.width * self.wall_n[1].width)
            self.bound.height = (self.wall_n[1].height * self.height +
                                 self.cren_n[1].height + isubheight)
            self.bound.midbottom = (self.middle, self.bottom)
            
            # Top of the current level
            top = self.bottom
            
            # Left of the tower
            left_level = self.bound.left
        
            # Iterate over the levels of the tower.
            for level in range(self.height) :
                
                # Move to to the top of the level.
                top -= self.wall_l[1].height

                # Left of the current block.
                left = left_level
                
                # Do the left most block
                surface.blit(self.wall_l[0], (left, top))
                
                # Update the position
                left += self.wall_l[1].width

                # Iterate over the blocks in the current level.
                for block in range(self.width/2) :
                    
                    # Draw the current block.
                    surface.blit(self.wall_n[0], (left, top))
                    
                    # Update the position
                    left += self.wall_n[1].width

                # If we have a parial block ...
                if isubwidth != 0 :

                    # ... blit it.
                    surface.blit(self.wall_n[0], (left, top),
                                 Rect(isubleft, 0, isubwidth,
                                      self.wall_n[1].height))
                        
                    # Update the position
                    left += isubwidth
                        
                # Iterate over the blocks in the current level.
                for block in range(self.width/2, self.width) :
                    
                    # Draw the current block.
                    surface.blit(self.wall_n[0], (left, top))
                   
                    # Update the position
                    left += self.wall_n[1].width

                # Do the right most block
                surface.blit(self.wall_r[0], (left, top))

            # If we have a partial level
            if isubheight != 0 :
            
                # Move to to the top of the level.
                top -= isubheight

                # Left of the current block.
                left = left_level
            
                # Do the left most block
                surface.blit(self.wall_l[0], (left, top),
                             Rect(0, 0, self.wall_l[1].height, isubheight))

                # Update the position
                left += self.wall_l[1].width

                # Iterate over the blocks in the current level.
                for block in range(self.width/2) :
                    
                    # Draw the current block.
                    surface.blit(self.wall_n[0], (left, top),
                                 Rect(0, 0, self.wall_n[1].height, isubheight))
                    
                    # Update the position
                    left += self.wall_n[1].width

                # If we have a parial block ...
                if isubwidth != 0 :

                    # ... blit it.
                    surface.blit(self.wall_n[0], (left, top),
                                 Rect(isubleft, 0, isubwidth, isubheight))

                    # Update the position
                    left += isubwidth
                
                # Iterate over the blocks in the current level.
                for block in range(self.width/2, self.width) :
                    
                    # Draw the current block.
                    surface.blit(self.wall_n[0], (left, top),
                                 Rect(0, 0, self.wall_n[1].height, isubheight))
                   
                    # Update the position
                    left += self.wall_n[1].width

                # Do the right most block
                surface.blit(self.wall_r[0], (left, top),
                                 Rect(0, 0, self.wall_n[1].height, isubheight))

            # Do the crenellations, Move to to the top of the level.
            top -= self.cren_l[1].height
        
            # Left of the current block.
            left = left_level
        
            # Do the left most block
            surface.blit(self.cren_l[0], (left, top))

            # Update the position
            left += self.cren_l[1].width
                
            # Iterate over the blocks in the current level.
            for block in range(self.width/2):

                # Draw the current block.
                surface.blit(self.cren_n[0], (left, top))
            
                # Update the position
                left += self.cren_n[1].width
                
            # If we have a parial block ...
            if isubwidth != 0 :

                # ... blit it.
                surface.blit(self.cren_n[0], (left, top),
                             Rect(isubleft, 0, isubwidth, self.wall_n[1].height))

                # Update the position
                left += isubwidth
            
            # Iterate over the blocks in the current level.
            for block in range(self.width/2, self.width):

                # Draw the current block.
                surface.blit(self.cren_n[0], (left, top))
            
                # Update the position
                left += self.cren_n[1].width
                
            # Do the right most block
            surface.blit(self.cren_r[0], (left, top))

            # Store the old size.
            self.oldwidth     = self.width
            self.oldheight    = self.height
            self.oldsubwidth  = self.subwidth
            self.oldsubheight = self.subheight

            list.append(self.bound)

        if((self.state != 0) or (self.oldstate != 0)) :
            pygame.draw.rect(surface, (0, 204, 255), self.ctrlrect)
            if(self.state != 0) :
                l1x = self.ctrlrad * self.orient
                l1y = 0
                pygame.draw.line(surface, (255, 0, 0), self.ctrlrect.center,
                                 (l1x+self.ctrlrect.centerx, l1y+self.ctrlrect.centery))
                l2x = l1x * math.cos(self.angle1 * self.orient) + l1y * math.sin(self.angle1 * self.orient)
                l2y = - l1x * math.sin(self.angle1 * self.orient) + l1y * math.cos(self.angle1 * self.orient)
                pygame.draw.line(surface, (255, 0, 0), self.ctrlrect.center, 
                                 (l2x+self.ctrlrect.centerx, l2y+self.ctrlrect.centery))
                if self.state == 2:
                    l2x = l1x * math.cos(self.angle2 * self.orient) + l1y * math.sin(self.angle2 * self.orient)
                    l2y = - l1x * math.sin(self.angle2 * self.orient) + l1y * math.cos(self.angle2 * self.orient)
                    pygame.draw.line(surface, (255, 0, 0), self.ctrlrect.center,
                                     (l2x+self.ctrlrect.centerx, l2y+self.ctrlrect.centery))
            self.oldstate = self.state
            list.append(self.ctrlrect)

        if(self.oldstrength != self.strength):
            pygame.draw.rect(surface, (0, 0, 0), self.strengthrect)
            strength = self.strength
            if strength < 0.0:
                strength = 0.0
            pygame.draw.rect(surface, (255, 255, 255),
                             Rect(self.strengthrect.topleft,
                                  (int(self.strengthrect.width * strength),
                                   self.strengthrect.height)))
            pygame.draw.rect(surface, (255, 0, 0), self.strengthrect, 1)
            self.oldstrength = self.strength
            list.append(self.strengthrect)
            
        if(self.oldpower != self.power):
            pygame.draw.rect(surface, (0, 0, 0), self.powerrect)
            pygame.draw.rect(surface, (255, 255, 255),
                             Rect(self.powerrect.topleft,
                                  (int(self.powerrect.width * self.power),
                                   self.powerrect.height)))
            pygame.draw.rect(surface, (0, 0, 255), self.powerrect, 1)
            self.oldpower = self.power
            list.append(self.powerrect)
            
        # Return the bound.
        return list

    def grow(self):

        if(self.target < 8) :
            self.target += 1

    def shrink(self):

        if(self.target > 0) :
            self.target -= 1

    def inflict(self, speed):

        if speed > 100.0:
            speed = 100.0
        self.strength -= speed / (500.0 * (self.actual+1))

    def control(self):

        if((self.state == 0) and (self.power < 0.1)):
            return
        if(self.state == 0):
            self.power -= 0.1
            
        if(self.state != 3) :
            self.state += 1
            if(self.state == 1) :
                self.angle1 = 0.0
            if(self.state == 2) :
                self.angle2 = self.angle1

    def repair(self):
        if(self.strength < 1.0) :
            reqpower = (1.0 - self.strength) * 50 *(self.actual+1) / 12
            if(self.power >= reqpower):
                self.strength = 1.0
                self.power -= reqpower
            else:
                self.strength += 12 * self.power / (50 * (self.actual+1))
                self.power = 0.0
            
    def collcheck(self, x, y):
        return self.bound.collidepoint(x,y)
    
    def update(self, miliseconds, all, missiles):

        if self.state == 1:
            self.angle1 += float(miliseconds)/1000.0
            if(self.angle1 > math.pi):
                self.angle1 = math.pi
                self.control()
        if self.state == 2:
            self.angle2 -= float(miliseconds)/1000.0
            if(self.angle2 < 0.0):
                self.angle2 = 0.0
                self.control()
        if self.state == 3:
            self.state = 0
            speed = self.angle1 * 100 / math.pi
            rs.resources.AddSound('cat', 'cat.wav').play()
            sheeps = sheep.Sheep(self.bound.centerx + self.orient * 5 * math.cos(self.angle2),
                                 int(self.bound.top - 5 * math.sin(self.angle2)) + 0, 0,
                                self.orient * speed * math.cos(self.angle2),
                                -speed * math.sin(self.angle2), 180, 0)
            all.add(sheeps)
            missiles.add(sheeps) 

        if(self.strength < 1.0) :
            self.strength += float(miliseconds)/(500000.0  * (self.actual+1))
            self.power += float(miliseconds)/120000.0
        else:
            self.power += float(miliseconds)/60000.0
        if((self.power > 1.0) and (self.target < 8)) :
            self.target += 1
            self.power -= 0.9

        if(self.power > 1.0):
            self.power = 1.0
            
        # If the target is met.
        if ((self.actual == self.target) and (self.subactual < 0.0)) :
            return

        if(self.subactual < 0.0) :
            self.subactual = 0.0
            
        if(self.target > self.actual) :

            self.subactual += float(miliseconds)/1000.0
            if(self.subactual >= 1.0) :
                
                self.actual += 1
                self.subactual -= 1.0
                
                if(self.actual == self.target) :
                    self.subactual = -1.0
        else :
            self.subactual -= float(miliseconds)/1000.0

            if(self.subactual < 0.0) :
                 if(self.actual == self.target) :
                    self.subactual = -1.0
                 else :
                     self.actual -= 1
                     self.subactual += 1.0

        self.width      = (0, 0, 0, 0, 1, 1, 1, 1, 2)[self.actual]
        self.height     = (0, 1, 2, 3, 3, 4, 5, 6, 6)[self.actual]
        if self.subactual < 0.0 :
            self.subwidth  = 0.0
            self.subheight = 0.0
        else :
            self.subwidth  = ((0, 0, 0, 1, 0, 0, 0, 1, 0)[self.actual] *
                              self.subactual)
            self.subheight = ((1, 1, 1, 0, 1, 1, 1, 0, 0)[self.actual] *
                              self.subactual)
    
