#
# The sheep object

# Import system stuff
import pygame
from pygame.locals import *

# Import local stuff
import rs

class Sheep(pygame.sprite.Sprite) :

    # Constructor
    def __init__(self, sx, sy, sa, dx, dy, da, drag):

        # Call the parents constructor
        pygame.sprite.Sprite.__init__(self)
        
        # Get the image of the sheep
        self.baseimage = rs.resources.AddImage('sheep', 'sheep.bmp',
                                                      (0, 204, 255))

        # Store the current position.
        self.x = sx;
        self.y = sy;
        self.a = sa;

        # Store the motion.
        self.dx = dx;
        self.dy = dy;
        self.da = da;

        self.age = 0;
        # Generate image.
        self.Generate()

    def Generate(self):

        # Create the current image.
        self.image = pygame.transform.rotate(self.baseimage[0], self.a)
        self.rect = self.image.get_rect()
        self.rect.center = (int(self.x), int(self.y))
        
    def update(self, miliseconds):

        if(self.age >= 0) :
            self.age += miliseconds
            if(self.age > 1000) :
                rs.resources.AddSound('baa', 'baa.wav').play()
                self.age = -1

        # Compute the update interval
        interval = float(miliseconds) / 1000.0
        
        # Update the position of the sheep.
        self.x += self.dx * interval
        self.y += self.dy * interval
        self.a += self.da * interval
        if(self.a > 360.0) :
            self.a -= 360.0
        if(self.a < 0.0)   :
            self.a += 360.0

        # Update the velocity.
        self.dy += 10.0 * interval

        # Update the image
        self.Generate()
