#
# Image resource container.
#   This maintains a list of surfaces containing images pre-converted to the
#   format being used on the screen. It saves reloading stuff.

# Import useful stuff
import os, sys
import pygame

class Resource_Manager :
    """Maintains a set of images converted to screen format."""

    # Constructor
    def __init__(self, basedir=None):

        # Set the sprite dictionary.
        self.sprites = {}
        
        # Set the sound dictionary.
        self.sounds = {}

        # Set the initial base directory.
        self.SetBaseDir(basedir)

    # Set the base directory for images.
    def SetBaseDir(self, basedir=None):
   
        # If we have a base dir ...
        if basedir is not None :
            self.basedir = os.path.join(basedir, 'data')
        else :
            self.basedir = 'data'
            
    def AddImage(self, name, filename, key):
        
        # If there is not a resouce by the supplied name ...
        if not self.sprites.has_key(name) :

            # Get the full filename
            full_filename = os.path.join(self.basedir, filename)
            
            # Try to load the image.
            try:
                image = pygame.image.load(full_filename)
            except pygame.error, message:
                print 'Cannot load sprite image:', name
                raise SystemExit, message
            
            # Convert the image.
            image = image.convert()
            
            # Set the colour key. If there is a key ...
            if key is not None:
                
                # ... if we need to get it from the image ...
                if key is -1:
                    
                    # ... do so.
                    key = image.get_at((0,0))
                    
                # And set the key.
                image.set_colorkey(key, pygame.locals.RLEACCEL)
                    
            # Store the image in the dictionary.
            self.sprites[name] = image, image.get_rect()

        # Return the image and rect.
        return self.sprites[name]
        
    def AddSound(self, name, filename):
        
        class NoneSound:
            def play(self): pass
            
        # If there is not a resouce by the supplied name ...
        if not self.sounds.has_key(name) :

            # Get the full filename
            full_filename = os.path.join(self.basedir, filename)

            # Try to load the image.
            if not pygame.mixer:
                sound = NoneSound()
            else :
                try:
                    sound = pygame.mixer.Sound(full_filename)
                except pygame.error, message:
                    print 'Cannot load sound:', name
                    raise SystemExit, message

            # Store the sound in the dictionary.
            self.sounds[name] = sound

        # Return the image and rect.
        return self.sounds[name]


# Global resource image object
resources = Resource_Manager()


