
# Import all the important functions
import os, sys
import pygame
import math
import random

from pygame.locals import *

# Import local stuff
import rs
import bg
import splat

# Initialise the pygame system
pygame.init()

# Get the main window surface.
screen = pygame.display.set_mode((640, 480))

# Set the title of the window.
pygame.display.set_caption('Sheep-a-pult by R.J.Patenall (robot_guy)')

# Get rid of the mouse
pygame.mouse.set_visible(0)

# Create the ground.
background = bg.Background(screen)

# Clock object to control frame rate.
clock = pygame.time.Clock()

all = pygame.sprite.RenderUpdates()
missiles = pygame.sprite.Group()

# Flag indicating that we want to quit.
quit_flag = 0

ai_state = 0
ai_reload = 0

players = 0
# Main Loop
while not quit_flag:
    clock.tick(60)

    # Process the events.
    for event in pygame.event.get():
        if event.type is QUIT:
            quit_flag = 1
        elif event.type is KEYDOWN:
            if event.key == K_ESCAPE:
                quit_flag = 1
            if players == 0:
                if event.key == K_1:
                    players = 1
                    background.play = 1
                elif event.key == K_2:
                    players = 2
                    background.play = 1
                    
            if ((background.win == 0) and (players != 0)):
               if event.key == K_q:
                   background.tower1.control()
               elif event.key == K_a:
                   background.tower1.repair()
               if(players==2):
                   if event.key == K_o:
                       background.tower2.control()
                   elif event.key == K_k:
                       background.tower2.repair()
                   
    if((players==1) and (background.win == 0)):
        ai_reload -= 60
        if((background.tower2.strength < 0.7) and (ai_state==0) and (background.tower2.power > 0.2)):
            background.tower2.repair()
        if((ai_state==0) and (background.tower2.power > 0.1) and (ai_reload <= 0)):
            ai_angle1 = math.pi * (random.random() * 0.2 +0.7)
            ai_angle2 = math.pi * (random.random() * 0.15 +0.05)
            ai_state=1
            ai_time =0
            background.tower2.control()
            ai_reload = 12000
            
        elif(ai_state==1):
            ai_time+=60
            if(ai_time/1000.0 >ai_angle1):
                background.tower2.control()
                ai_state=2
                ai_time =0
        elif(ai_state==2):
            ai_time+=60
            if(ai_time/1000.0 > (ai_angle1-ai_angle2)):
                background.tower2.control()
                ai_state=0
                ai_time =0

           
            
        
        
    # Update all the sprites
    all.clear(screen, background.image)
    if(players == 0):
        all.update(0)
        background.update(0,all,missiles)
    else:
        all.update(60)
        background.update(60,all,missiles)
    for missile in missiles.sprites():
        if((screen.get_rect().height < missile.rect.top) or
           (missile.rect.right < 0) or (missile.rect.left > screen.get_rect().width)):
            missile.kill()

        if background.tower2.collcheck(missile.rect.centerx,
                                       missile.rect.centery):
            speed = math.sqrt(missile.dx * missile.dx + missile.dy * missile.dy)
            background.tower2.inflict(speed)
            all.add(splat.Splat(missile));
            missile.kill()
        if background.tower1.collcheck(missile.rect.centerx,
                                       missile.rect.centery):
            speed = math.sqrt(missile.dx * missile.dx + missile.dy * missile.dy)
            background.tower1.inflict(speed)
            all.add(splat.Splat(missile));
            missile.kill()
        if missile.rect.centery > background.grass :
            all.add(splat.Splat(missile));
            missile.kill()

    if((background.tower2.strength <= 0.0) and (background.win == 0)):
        background.win = 1
        rs.resources.AddSound('win1', 'win1.wav').play()

    if((background.tower1.strength <= 0.0) and (background.win == 0)):
        background.win = 2
        rs.resources.AddSound('win1', 'win1.wav').play()

        
    background.Draw(screen);
    areas = all.draw(screen)
    
    background.Changes(areas)
    pygame.display.update(areas)
    #pygame.display.update()

