#
# The background object
#   This generates the background image for the game. This includes the
#   sky, ground and towers

# Import system stuff
import pygame
from pygame.locals import *

# Import local stuff
import rs
import tower

class Background :

    # Constructor
    def __init__(self, screen):

        # Add the grass to the list of resources.
        grass = rs.resources.AddImage('grass', 'grass.bmp', None)
        
        # Create the backgroundground surface.
        self.image = pygame.Surface(screen.get_size())
        self.image = self.image.convert();

        # Fill the sky.
        self.image.fill((0, 204, 255))

        # Draw the grass
        self.grass = screen.get_height() - grass[1].height
        right = screen.get_width()
        left = 0
        while left < right :
            self.image.blit(grass[0], (left, self.grass))
            left += grass[1].width

            
        self.tower1 = tower.Tower(64, self.grass, 1)
        self.tower1.Draw(self.image)
        self.tower2 = tower.Tower(right-64, self.grass, -1)
        self.tower2.Draw(self.image)
        self.oldplay = -1
        self.play = 0
        self.win = 0;
        self.oldwin = 0;
        # Set a update.
        self.updates = [Rect((0, 0), screen.get_size())]

    # Append a list of changes
    def Changes(self, list):

        # Add the changes to the list.
        list[len(list):] = self.updates

        # Clear the updates.
        self.updates = []

    def Draw(self, screen):

        # Draw any updates.
        for area in self.updates:
            screen.blit(self.image, area.topleft, area)

    # Update method
    def update(self, miliseconds, all, missiles):
        "Actually does nothing at the moment."

        self.tower1.update(miliseconds, all, missiles)
        self.updates[len(self.updates):] = self.tower1.Draw(self.image)
        self.tower2.update(miliseconds, all, missiles)
        self.updates[len(self.updates):] = self.tower2.Draw(self.image)
        if self.oldplay != self.play:
            if self.play == 0:
                img2, rect =  rs.resources.AddImage('1or2', '1or2.bmp', (0,204,255))
                self.image.blit(img2, ((self.image.get_width() - rect.width) / 2, 25))
                self.updates = [Rect((0, 0), self.image.get_size())]
            else:
                img2, rect =  rs.resources.AddImage('1or2', '1or2.bmp', (0,204,255))
                pygame.draw.rect(self.image, (0,204,255), Rect((self.image.get_width() - rect.width) / 2, 25, rect.width, rect.height))
                self.updates = [Rect((0, 0), self.image.get_size())]
            self.oldplay = self.play
                
        if self.oldwin != self.win:
            if self.win != 0:
                img, rect =  rs.resources.AddImage('gameover', 'gameover.bmp', (0,204,255))
                self.image.blit(img, ((self.image.get_width() - rect.width) / 2, 25))
                if self.win == 1:
                    img, rect =  rs.resources.AddImage('p1', 'player1.bmp', (0,204,255))
                else :
                    img, rect =  rs.resources.AddImage('p2', 'player2.bmp', (0,204,255))
                self.image.blit(img, ((self.image.get_width() - rect.width) / 2, 125))
                img, rect =  rs.resources.AddImage('wins', 'wins.bmp', (0,204,255))
                self.image.blit(img, ((self.image.get_width() - rect.width) / 2, 250))
                self.updates = [Rect((0, 0), self.image.get_size())]

            self.oldwin = self.win
