#! /usr/bin/env python
import os, sys, pygame, operator
from pygame.locals import *
from random import Random
from time import time
from copy import copy

#--------0---------0---------0---------0---------0---------0---------0---------0
def CutScene( bgSurface, screen ):
	screen.blit(bgSurface, (0,0) )
	pygame.display.flip()
	while 1:
		for event in pygame.event.get():
			if event.type == QUIT \
			  or (event.type == KEYDOWN and event.key == K_ESCAPE):
				return
			elif event.type == MOUSEBUTTONDOWN:
				return

#--------0---------0---------0---------0---------0---------0---------0---------0
def load_sound(name, prefix):
	class NoneSound:
		def play(self): pass
	if not pygame.mixer:
		return NoneSound()
	fullname = os.path.join('data', 's_'+prefix+name+'.wav')
	try:
		sound = pygame.mixer.Sound(fullname)
	except pygame.error, message:
		print 'Cannot load sound:', fullname
		raise SystemExit, message
	return sound
#--------0---------0---------0---------0---------0---------0---------0---------0
def load_png( name, extradir=''):
	fullname = os.path.join('data', extradir, name)
	try:
		image = pygame.image.load(fullname)
		if image.get_alpha is None:
			image = image.convert()
		else:
			image = image.convert_alpha()
	except pygame.error, message:
		print 'Cannot load png:', fullname
		raise SystemExit, message
	return image, image.get_rect()


#--------0---------0---------0---------0---------0---------0---------0---------0
def GetMoveStateFor(fromRect,toRect):
	print "from", fromRect
	print "to", toRect
	rise = toRect.centery - fromRect.centery
	run  = toRect.centerx - fromRect.centerx

	print "rise ", rise, " run ", run

	absRise = abs(rise)
	absRun = abs(run)
	if absRise > absRun:
		rise = rise/absRise
		run = float(run)/absRise
	else:
		run = run/absRun
		rise = float(rise)/absRun

	print "calculated move: ", [run,rise]
	return [run,rise]

#--------0---------0---------0---------0---------0---------0---------0---------0
class Level:
	def __init__(self, game):
		self.game = game
		self.bgSurface, devnull = load_png('backgr.png')
		self.titleSurface, devnull = load_png('level1_title.png')
		self.grassGrowthRate = 3
		self.maxGrass = 50
		self.totalGrass = 60

	def Build(self):
		pass
	
	def GetBackground(self):
		return self.bgSurface

	def CutScene( self, screen ):
		screen.blit(self.titleSurface, (0,0) )
		pygame.display.flip()
		done = 0
		while 1:
			if done == 1:
				break
			for event in pygame.event.get():
				if event.type == QUIT \
				  or event.type == KEYDOWN \
				  or event.type == MOUSEBUTTONDOWN:
					done = 1
		#self.bgSurface = self.level.GetBackground()
		screen.blit(self.bgSurface, (0,0) )
		pygame.display.flip()
		return self.bgSurface



#--------0---------0---------0---------0---------0---------0---------0---------0
class Level1(Level):
	def __init__(self, game):
		Level.__init__(self,game)
		self.grassGrowthRate = 3
		self.maxGrass = 50
		self.totalGrass = 60

	def Build(self):
		fence = Fence(self.game, [770,100])
		fence = Fence(self.game, [770,150])
		fence = Fence(self.game, [770,200])
		fence = Fence(self.game, [770,250])
		fence = Fence(self.game, [770,300])
		fence = Fence(self.game, [770,400])
		fence = Fence(self.game, [770,550])
		fence = Fence(self.game, [770,600])
	


#--------0---------0---------0---------0---------0---------0---------0---------0
class Level2(Level):
	def __init__(self, game):
		Level.__init__(self,game)
		self.titleSurface, devnull = load_png('level2_title.png')
		self.grassGrowthRate = 3
		self.maxGrass = 10
		self.totalGrass = 60

	def Build(self):
		fence = Fence(self.game, [770,100])
		fence = Fence(self.game, [770,150])
		fence = Fence(self.game, [770,200])
		fence = Fence(self.game, [770,250])
		#fence = Fence(self.game, [770,300])
		fence = Fence(self.game, [770,450])
		fence = Fence(self.game, [770,500])
		fence = Fence(self.game, [770,550])
		fence = Fence(self.game, [770,600])

		fence = Fence(self.game, [670,200])
		fence = Fence(self.game, [670,250])
		fence = Fence(self.game, [670,300])
		fence = Fence(self.game, [670,350])
		fence = Fence(self.game, [670,400])
		fence = Fence(self.game, [670,450])
		fence = Fence(self.game, [670,500])
		#fence = Fence(self.game, [670,600])

#--------0---------0---------0---------0---------0---------0---------0---------0
class Level3(Level):
	def __init__(self, game):
		Level.__init__(self,game)
		self.titleSurface, devnull = load_png('level3_title.png')
		self.grassGrowthRate = 3
		self.maxGrass = 50
		self.totalGrass = 100

	def Build(self):
		fence = Fence(self.game, [770,100])
		fence = Fence(self.game, [770,150])
		fence = Fence(self.game, [770,200])
		fence = Fence(self.game, [770,250])
		fence = Fence(self.game, [770,300])
		fence = Fence(self.game, [770,350])
		fence = Fence(self.game, [770,400])
		fence = Fence(self.game, [770,450])
		fence = Fence(self.game, [770,450])
		fence = Fence(self.game, [770,500])
		fence = Fence(self.game, [770,550])
		fence = Fence(self.game, [770,600])

		fence = Fence(self.game, [710,100])
		fence = Fence(self.game, [710,150])
		fence = Fence(self.game, [710,200])

		fence = Fence(self.game, [710,500])
		fence = Fence(self.game, [710,550])
		fence = Fence(self.game, [710,600])

		fence = Fence(self.game, [50,450])
		fence = Fence(self.game, [50,500])
		fence = Fence(self.game, [50,550])
		fence = Fence(self.game, [50,600])

		fence = Fence(self.game, [350,450])
		fence = Fence(self.game, [350,450])
		fence = Fence(self.game, [350,500])
		fence = Fence(self.game, [350,550])
		fence = Fence(self.game, [350,600])


		fence = Fence(self.game, [470,450])
		fence = Fence(self.game, [470,500])
		fence = Fence(self.game, [470,550])
		fence = Fence(self.game, [470,600])



#--------0---------0---------0---------0---------0---------0---------0---------0
class Level4(Level):
	def __init__(self, game):
		Level.__init__(self,game)
		self.titleSurface, devnull = load_png('level4_title.png')
		self.grassGrowthRate = 2
		self.maxGrass = 10
		self.totalGrass = 60

	def Build(self):
		fence = Fence(self.game, [770,100])
		fence = Fence(self.game, [770,150])
		fence = ScottishScarecrow(self.game, [770,265])
		fence = ScottishScarecrow(self.game, [770,485])
		fence = Fence(self.game, [770,600])
		fence = Fence(self.game, [770,650])
		fence = Fence(self.game, [770,700])

		fence = Fence(self.game, [50,450])
		fence = Fence(self.game, [50,500])
		fence = Fence(self.game, [50,550])
		fence = Fence(self.game, [50,600])
		fence = Fence(self.game, [100,450])
		fence = Fence(self.game, [150,450])

		fence = Fence(self.game, [250,450])
		fence = Fence(self.game, [300,450])
		fence = Fence(self.game, [350,450])
		fence = Fence(self.game, [350,450])
		fence = Fence(self.game, [350,500])
		fence = Fence(self.game, [350,550])
		fence = Fence(self.game, [350,600])

#--------0---------0---------0---------0---------0---------0---------0---------0
class Level5(Level):
	def __init__(self, game):
		Level.__init__(self,game)
		self.titleSurface, devnull = load_png('level5_title.png')
		self.grassGrowthRate = 7
		self.maxGrass = 20
		self.totalGrass = 60

	def Build(self):
		fence = SheepGun(self.game, [770,150])
		fence = Fence(self.game, [770,260])
		fence = Fence(self.game, [770,300])
		fence = Fence(self.game, [770,340])
		fence = Fence(self.game, [770,380])
		fence = Fence(self.game, [770,420])
		fence = Fence(self.game, [770,460])
		fence = Fence(self.game, [770,500])
		fence = SheepGun(self.game, [770,570])


		fence = Fence(self.game, [550,100])
		fence = Fence(self.game, [550,140])
		fence = Fence(self.game, [550,180])
		fence = Fence(self.game, [550,220])

		fence = Fence(self.game, [550,480])
		fence = Fence(self.game, [550,520])
		fence = Fence(self.game, [550,560])
		fence = Fence(self.game, [550,600])


#--------0---------0---------0---------0---------0---------0---------0---------0
class Level6(Level):
	def __init__(self, game):
		Level.__init__(self,game)
		self.bgSurface, devnull = load_png('backgr2.png')
		self.titleSurface, devnull = load_png('level6_title.png')
		self.grassGrowthRate = 7
		self.maxGrass = 20
		self.totalGrass = 20

	def Build(self):
		fence = SheepGun(self.game, [770,150])
		fence = Fence(self.game, [770,260])
		fence = Fence(self.game, [770,300])
		fence = Fence(self.game, [770,340])
		fence = Fence(self.game, [770,380])
		fence = Fence(self.game, [770,420])
		fence = Fence(self.game, [770,460])
		fence = Fence(self.game, [770,500])
		fence = SheepGun(self.game, [770,570])

		fence = ScottishScarecrow(self.game, [10,300])

		fence = Fence(self.game, [600,200])
		fence = Fence(self.game, [620,240])
		fence = Fence(self.game, [620,500])
		fence = Fence(self.game, [600,540])



#--------0---------0---------0---------0---------0---------0---------0---------0
class Player:
	def __init__(self, game, tickSprite,two):
		self.game = game
		self.two = two
		self.tickSprite = tickSprite
		self.money = 300
		self.antibioticCounter = 0
		self.maxTicks = 3 
		self.tickCounter = 0
		self.labBImage, d = load_png( 'labbutton.png' )

	def Tick(self):
		#every 10 ticks, you have to buy antibiotics & growth hormone
		self.antibioticCounter = self.antibioticCounter +1
		self.tickCounter = self.tickCounter + 1
		if self.antibioticCounter > 9:
			self.antibioticCounter = 0
			charge = 10 + 10 * len(self.game.sheepGroup)
			self.SetMoney( self.money - charge )
		if self.tickCounter > self.maxTicks:
			self.tickCounter = 0
			self.game.PlayerEndsTurn(self)
		if self.two:
			self.tickSprite.SetText( str(self.maxTicks - self.tickCounter) )
		else:
			self.tickSprite.SetText( str(9 - self.antibioticCounter) )

	def SetMoney(self, amt):
		self.money = amt
		if self.money < 0:
			self.game.End( "You're Fired!  You ran out of money!" )

	def GetLabButtonImg(self):
		return self.labBImage

#--------0---------0---------0---------0---------0---------0---------0---------0
class DefendPlayer(Player):
	def __init__(self, game, tickSprite,two):
		Player.__init__(self,game,tickSprite,two)
		self.labBImage, d = load_png( 'shedbutton.png' )

	def Tick(self):
		print " I am player 2!"
		self.tickCounter = self.tickCounter + 1
		if self.tickCounter > self.maxTicks:
			self.tickCounter = 0
			self.game.PlayerEndsTurn(self)
		self.tickSprite.SetText( str(self.maxTicks - self.tickCounter) )


#--------0---------0---------0---------0---------0---------0---------0---------0
#--------0---------0---------0---------0---------0---------0---------0---------0
class SheepGame:
	def __init__(self, screen, allSprites, bgSurface, twoPlayers=0 ):
		self.screen = screen
		self.bgSurface = bgSurface
		self.time = int(time())
		self.selectedSprite = None

		self.allowSignalsThrough = 1
		self.paused = 0
		self.sheepQueue = []

		self.allSprites = allSprites

		self.hudGroup = pygame.sprite.RenderClear()
		self.grassGroup = RectSmartGroup()
		self.sheepGroup = RectSmartGroup()
		self.fenceGroup = pygame.sprite.Group()
		self.mapGroup = pygame.sprite.Group()
		self.labGroup = pygame.sprite.RenderUpdates()
		self.gameOverGroup = pygame.sprite.RenderUpdates()

		self.tickSprite = TickSprite(self, None, str(10), [590,20])

		self.player1 = Player(self, self.tickSprite, twoPlayers)
		self.twoPlayers = twoPlayers
		if self.twoPlayers:
			self.player2 = DefendPlayer(self, self.tickSprite,twoPlayers)
		self.activePlayer = self.player1


		self.map = Map(self, screen, self.activePlayer)
		self.lab = Lab(self, screen, self.activePlayer)

		self.boundingRect = self.screen.get_rect()
		self.boundingRect.top = self.boundingRect.top + 80
		self.boundingRect.height = self.boundingRect.height - 80


		self.levels = [ Level1(self), 
		                Level2(self),
		                Level3(self),
		                Level4(self),
		                Level5(self),
		                Level6(self) ]
		#debugging
		#self.levels = [ Level6(self) ]
		#debugging
		self.levelCounter = 0
		self.level = None
		self.grassGrowthCounter = 0
		self.grassGrowthRate = 0
		self.maxGrass = 0
		self.totalGrass = 0

		self.LoadLevel()


		gb = GrassBloom(self.boundingRect, self)

		self.MakeSheepOfClass( Sheep, 1 )
		self.moneySprite = MoneySprite(self, screen, self.activePlayer)

		self.mode = 'field1'

	#----------------------------------------------------------------------
	def End( self, message ):
		print "GAME ENDS NOW!!!"
		over = HUDItem(self, self.screen, message)
		over.rect.center= (400,300)

		self.mode = 'over'
		self.paused = 1

	#----------------------------------------------------------------------
	def SheepEscape(self, sheep):
		print "SHEEP ESCAPE!"
		if not sheep.fertile:
			sheep.KillAllSprites()
			return
		over = HUDItem(self, self.screen, "Contamination Successful!")
		over.rect.center= (400,300)

		self.mode = 'over'
		self.paused = 1

		for sprite in self.sheepGroup.sprites() + \
		              self.grassGroup.sprites() + \
			      self.fenceGroup.sprites():
			sprite.KillAllSprites()

		self.levelCounter = self.levelCounter + 1
		if not self.LoadLevel():
			return

		self.MakeSheepOfClass( Sheep, 1 )
		self.mode = 'field1'
		self.paused = 0
		over.KillAllSprites()

	#----------------------------------------------------------------------
	def MakeSheepOfClass(self, sheepClass, delay=10):
		sheep = sheepClass(self,self.boundingRect,self.activePlayer)
		self.EnqueueSheep( sheep, delay )

	#----------------------------------------------------------------------
	def LoadLevel(self):
		if self.levelCounter > len(self.levels) - 1:
			return 0
		self.level = self.levels[self.levelCounter]
		self.level.Build();
		self.grassGrowthCounter = 0
		self.grassGrowthRate = self.level.grassGrowthRate
		self.maxGrass = self.level.maxGrass
		self.totalGrass = self.level.totalGrass

		#self.bgSurface, devnull = load_png('level1_title.png')
		self.bgSurface = self.level.CutScene( self.screen )
		#self.bgSurface = self.level.GetBackground()
		#self.screen.blit(self.bgSurface, (0,0) )
		#pygame.display.flip()

		return 1

	#----------------------------------------------------------------------
	def GetActiveGroups(self):
		if self.mode == 'field1':
			return self.allSprites
		elif self.mode == 'lab':
			return self.labGroup
		elif self.mode == 'over':
			return self.gameOverGroup

	#----------------------------------------------------------------------
	def GetBackground( self ):
		return self.bgSurface


	#----------------------------------------------------------------------
	def Tick(self):
		#every second
		if self.paused:
			return
		if int(time()) - self.time > 1:
			self.time = int(time())
			self.activePlayer.Tick()
			self.map.update()
			if len(self.grassGroup) < self.maxGrass \
			  and self.totalGrass > 0:
				self.grassGrowthCounter = self.grassGrowthCounter + 1
				if self.grassGrowthCounter >= self.grassGrowthRate:
					self.grassGrowthCounter = 0
					gb = GrassBloom(self.boundingRect, self)
			#gotta iterate backwards so deletions dont' affect order
			#print self.sheepQueue
			for i in range(len(self.sheepQueue)-1,-1,-1):
				if self.sheepQueue[i][0] <= self.time:
					self.sheepQueue[i][1].Birth()
					del self.sheepQueue[i]
	
	#----------------------------------------------------------------------
	def PlayerEndsTurn(self, player):
		print "ENDING TURN"
		if not self.twoPlayers:
			return
		if player is self.player1:
			self.activePlayer = self.player2
		else:
			self.activePlayer = self.player1
		self.moneySprite.SetPlayer( self.activePlayer )
		self.openLabButton.SetPlayer(self.activePlayer )


	#----------------------------------------------------------------------
	def RegisterSprite(self, newSprite):
		if isinstance(newSprite, HUDItem):
			self.hudGroup.add( newSprite )
			self.allSprites.add( newSprite )
			self.labGroup.add( newSprite )
			self.gameOverGroup.add( newSprite )

		if isinstance(newSprite, Grass):
			self.grassGroup.add( newSprite )
			self.allSprites.add( newSprite )
			self.totalGrass = self.totalGrass - 1
			
		if isinstance(newSprite, Fence):
			self.fenceGroup.add( newSprite )
			self.allSprites.add( newSprite )

		elif isinstance(newSprite, Sheep):
			self.sheepGroup.add( newSprite )
			self.allSprites.add( newSprite )

		elif isinstance(newSprite, Door ):
			self.door = newSprite
			self.mapGroup.add( newSprite )
			self.allSprites.add( newSprite )

		elif isinstance(newSprite, OpenLabButton) \
		  or isinstance(newSprite, TickSprite ):
			self.openLabButton = newSprite
			self.mapGroup.add( newSprite )
			self.allSprites.add( newSprite )

		elif ( isinstance(newSprite, LabButton ) \
		  and not isinstance(newSprite, TickSprite ) ) \
		  or isinstance(newSprite, LabMenu ):
			self.labGroup.add( newSprite )
		else:
			#unknown sprite?!?!
			self.allSprites.add( newSprite )


	#----------------------------------------------------------------------
	def SelectSprite(self, sprite):
		self.selectedSprite = sprite
		self.door.ImageOn()

	#----------------------------------------------------------------------
	def UnSelectSprite(self, sprite):
		if self.selectedSprite == sprite:
			self.selectedSprite = None
			self.door.ImageOff()

	#----------------------------------------------------------------------
	def EnqueueSheep(self, sheep, delay=10):
		self.sheepQueue.append( [self.time+delay, sheep] )
		
	#----------------------------------------------------------------------
	def OpenLab(self):
		self.mode = 'lab'
		self.paused = 1
		self.bgSurface, devnull = load_png('lab.png')
		self.screen.blit(self.bgSurface, (0,0) )
		pygame.display.flip()

	#----------------------------------------------------------------------
	def CloseLab(self):
		self.mode = 'field1'
		self.paused = 0
		self.bgSurface = self.level.GetBackground()
		#self.bgSurface, devnull = load_png('backgr.png')
		self.screen.blit(self.bgSurface, (0,0) )
		pygame.display.flip()



	#----------------------------------------------------------------------
	def UserEvent(self, event):
		if self.allowSignalsThrough and self.mode == 'field1':
			for sheep in self.sheepGroup.sprites():
				sheep.UserEvent( event, self.selectedSprite )
			for sprite in self.mapGroup.sprites():
				sprite.UserEvent( event, self.selectedSprite )
			for sprite in self.fenceGroup.sprites():
				sprite.UserEvent( event, self.selectedSprite )
			for sprite in self.grassGroup.sprites():
				sprite.UserEvent( event, self.selectedSprite )
		elif self.allowSignalsThrough and self.mode == 'lab':
			for sprite in self.labGroup.sprites():
				sprite.UserEvent( event, self.selectedSprite )

#--------0---------0---------0---------0---------0---------0---------0---------0
class Lab:
	def __init__(self, game, screen, player):
		self.screen = screen
		self.game = game
		self.player = player
		self.exitButton= LabButton(self.game, self, "Exit", [100,20],
		                           "",
		                           self.ClickExit, 60)
		self.sRButton= LabButton(self.game, self, "Regular GM", 
		                           [530,410],
		                           "",
		                           self.ClickSheepR)
		self.sHYButton= LabButton(self.game, self, "High Yield Genes", 
		                           [530,490],
		                           "",
		                           self.ClickSheepHY)
		self.sHYButton= LabButton(self.game, self, "Wood-Eating Genes", 
		                           [530,570],
		                           "",
		                           self.ClickSheepWE)
	
		self.selected = Sheep
		self.cost = 100
		self.menu = LabMenu(self.game,self,'menu_re.png',
		                           [120,175],
		                           self.ClickBuy)
		self.rImage = self.menu.image
		self.hImage,d = load_png( 'menu_hy.png' )
		self.wImage,d = load_png( 'menu_we.png' )
	
	
	def ClickExit(self):
		self.game.CloseLab()

	def ClickBuy(self):
		if self.player.money < self.cost:
			return
		self.player.money = self.player.money - self.cost
		self.game.MakeSheepOfClass( self.selected )

	def ClickSheepR(self):
		self.cost = 100
		self.selected = Sheep
		self.menu.image = self.rImage

	def ClickSheepHY(self):
		self.cost = 200
		self.selected = HighYieldSheep
		self.menu.image = self.hImage

	def ClickSheepWE(self):
		self.cost = 300
		self.selected = WoodEatingSheep
		self.menu.image = self.wImage
		
		

#--------0---------0---------0---------0---------0---------0---------0---------0
class LabMenu(pygame.sprite.Sprite):
	def __init__(self, game, lab, name, position, clickFn=None):
		pygame.sprite.Sprite.__init__(self)
		self.game = game
		self.lab = lab
		self.clickFn = clickFn

		self.image, self.rect = load_png(name)
		self.rect.topleft = position

		self.game.RegisterSprite(self)

	#----------------------------------------------------------------------
	def UserEvent(self, event, selectedSprite):
		if self.clickFn is not None and event.type == MOUSEBUTTONDOWN:
			clickBox = self.rect.inflate(20,20)
			if clickBox.collidepoint(pygame.mouse.get_pos()):
				self.clickFn()

#--------0---------0---------0---------0---------0---------0---------0---------0
class LabButton(pygame.sprite.Sprite):
	def __init__(self, game, lab, text, position, desc='', 
	             clickFn=None, fontSize=30):
		pygame.sprite.Sprite.__init__(self)
		self.game = game
		self.lab = lab
		self.desc = desc
		self.clickFn = clickFn
		self.fontSize = fontSize

		#self.SetText( text )
		font = pygame.font.Font(None, self.fontSize )
		self.image = font.render(text, 1, (0,0,0) )
		self.rect = self.image.get_rect()
		self.rect.topleft = position

		self.game.RegisterSprite(self)

	#----------------------------------------------------------------------
	def UserEvent(self, event, selectedSprite):
		if self.clickFn is not None and event.type == MOUSEBUTTONDOWN:
			clickBox = self.rect.inflate(20,20)
			if clickBox.collidepoint(pygame.mouse.get_pos()):
				self.clickFn()


#--------0---------0---------0---------0---------0---------0---------0---------0
class TickSprite(LabButton):
	#----------------------------------------------------------------------
	def SetText(self, text):
		font = pygame.font.Font(None, self.fontSize )
		self.image = font.render(text, 1, (0,0,0) )

#--------0---------0---------0---------0---------0---------0---------0---------0
class OpenLabButton(pygame.sprite.Sprite):
	def __init__(self, game):
		pygame.sprite.Sprite.__init__(self)
		self.game = game
		self.image, self.rect = load_png( 'labbutton.png' )
		self.rect.center = [60,40]

		game.RegisterSprite(self)

	#----------------------------------------------------------------------
	def UserEvent(self, event, selectedSprite):
		if event.type == MOUSEBUTTONDOWN:
			clickBox = self.rect.move(0,0)
			if clickBox.collidepoint(pygame.mouse.get_pos()):
				if selectedSprite is not None:
					selectedSprite.ActOn( self )

				if self.game.paused:
					self.game.CloseLab()
				else:
					self.game.OpenLab()

	#----------------------------------------------------------------------
	def SetPlayer(self, newPlayer):
		self.image = newPlayer.GetLabButtonImg()


#--------0---------0---------0---------0---------0---------0---------0---------0
class HUDItem(pygame.sprite.Sprite):
	def __init__(self, game, screen, text):
		pygame.sprite.Sprite.__init__(self)
		self.screen = screen
		self.game = game

		font = pygame.font.Font(None, 60 )
		self.image = font.render(text, 1, (0,0,0) )
		self.rect = self.image.get_rect()
		self.rect.topleft = (650,10)

		self.game.RegisterSprite(self)

	#----------------------------------------------------------------------
	def update(self):
		pass

	#----------------------------------------------------------------------
	def UserEvent(self, event, selectedSprite):
		pass

	#----------------------------------------------------------------------
	def KillAllSprites(self):
		self.kill()
		garbage.add( self )


#--------0---------0---------0---------0---------0---------0---------0---------0
class MoneySprite(HUDItem):
	def __init__(self, game, screen, player):
		self.player = player
		moneyStr = "$" + str(self.player.money)
		HUDItem.__init__(self,game,screen,moneyStr)

	#----------------------------------------------------------------------
	def update(self):
		moneyStr = "$" + str(self.player.money)
		font = pygame.font.Font(None, 60 )
		self.image = font.render(moneyStr, 1, (0,0,0) )

	#----------------------------------------------------------------------
	def SetPlayer(self, player):
		self.player = player


#--------0---------0---------0---------0---------0---------0---------0---------0
class Map:
	def __init__(self, game, screen, player):
		self.screen = screen
		self.game = game
		self.player = player
		self.door = Door(game)
		self.labButton = OpenLabButton(game)

	def update(self):
		pass
		


#--------0---------0---------0---------0---------0---------0---------0---------0
class Door(pygame.sprite.Sprite):
	def __init__(self, game):
		pygame.sprite.Sprite.__init__(self)
		self.game = game
		self.imageOff, self.rect = load_png( 'door.png' )
		self.imageOn, d = load_png( 'door_on.png' )
		self.image = self.imageOff
		self.rect.center = [300,90]

		game.RegisterSprite(self)
	#----------------------------------------------------------------------
	def ImageOn(self):
		self.image = self.imageOn
	#----------------------------------------------------------------------
	def ImageOff(self):
		self.image = self.imageOff

	#----------------------------------------------------------------------
	def UserEvent(self, event, selectedSprite):
		if event.type == MOUSEBUTTONDOWN:
			clickBox = self.rect.inflate(-10,-10)
			if clickBox.collidepoint(pygame.mouse.get_pos()):
				if selectedSprite is not None:
					selectedSprite.ActOn( self )



#--------0---------0---------0---------0---------0---------0---------0---------0
class GrassBloom:
	def __init__(self, boundingRect, game):
		#decide where I'll sprout up
		bRect = boundingRect.inflate( -70, -70 )

		print bRect
		w = bRect.width
		h = bRect.height
		x = int(rng.normalvariate( w/2, w/4 )) % w
		y = int(rng.normalvariate( h/2, h/4 )) % h

		#print x, y
		
		#that gives us the x,y INSIDE the bBox, now we 
		#need the ABSOLUTE x and y
		x = bRect.left + x
		y = bRect.top + y

		#print x, y

		displacement = rng.randint(20,65)

		newGrass = Grass(game)
		newGrass.rect.center = (x+displacement,y)
		newGrass = Grass(game)
		newGrass.rect.center = (x-displacement,y+displacement-20)
		newGrass = Grass(game)
		newGrass.rect.center = (x,y-displacement)
		#print "Making a new grass sprite at ", x," ",y



#--------0---------0---------0---------0---------0---------0---------0---------0
class Grass(pygame.sprite.Sprite):
	def __init__(self, game):
		pygame.sprite.Sprite.__init__(self)
		self.image, self.rect = load_png( 'grass.png' )
		self.health = 100

		game.RegisterSprite(self)

	#----------------------------------------------------------------------
	def TakeBite(self):
		self.health = self.health - 50
		if self.health <= 0:
			self.KillAllSprites()

	#----------------------------------------------------------------------
	def KillAllSprites(self):
		self.kill()
		garbage.add( self )

	#----------------------------------------------------------------------
	def UserEvent(self, event, selectedSprite):
		if event.type == MOUSEBUTTONDOWN:
			clickBox = self.rect.inflate(-10,-10)
			if clickBox.collidepoint(pygame.mouse.get_pos()):
				print "I got a user event!  I am a", \
				       self.__class__
				if selectedSprite is not None:
					selectedSprite.ActOn( self )




#--------0---------0---------0---------0---------0---------0---------0---------0
class Fence(pygame.sprite.Sprite):
	def __init__(self, game, position,prefix=''):
		pygame.sprite.Sprite.__init__(self)
		self.game = game
		self.image, self.rect = load_png( prefix + 'fence.png' )
		self.health = 100

		self.rect.inflate_ip( -10, 0 )
		self.rect.center = position

		game.RegisterSprite(self)

	#----------------------------------------------------------------------
	def TakeBite(self):
		print "FENCE: ouch! someone bit me"
		self.health = self.health - 10
		if self.health <= 0:
			self.KillAllSprites()
		
	#----------------------------------------------------------------------
	def Bump(self, sheep):
		pass

	#----------------------------------------------------------------------
	def KillAllSprites(self):
		center = self.rect.center
		self.rect.inflate_ip( 10, 0 )
		self.rect.center = center
		self.kill()
		garbage.add( self )

	#----------------------------------------------------------------------
	def UserEvent(self, event, selectedSprite):
		if event.type == MOUSEBUTTONDOWN:
			clickBox = self.rect.inflate(-10,-10)
			if clickBox.collidepoint(pygame.mouse.get_pos()):
				print "I got a user event!  I am a", \
				       self.__class__
				if selectedSprite is not None:
					selectedSprite.ActOn( self )


#--------0---------0---------0---------0---------0---------0---------0---------0
class WoodFence(Fence):
	pass

#--------0---------0---------0---------0---------0---------0---------0---------0
class ScottishScarecrow(Fence):
	def __init__(self,game,position):
		Fence.__init__(self,game,position,"sc_")

	#----------------------------------------------------------------------
	def Bump(self, sheep):
		direction = [0,0]
		if self.rect.centery +20 - sheep.rect.centery > 0:
			direction[1] = 1
		elif self.rect.centery -20 - sheep.rect.centery < 0:
			direction[1] = -1
		if self.rect.centerx - sheep.rect.centerx > 0:
			direction[0] = -1
		if self.rect.centerx - sheep.rect.centerx < 0:
			direction[0] = 1
		sheep.Frighten( direction )

#--------0---------0---------0---------0---------0---------0---------0---------0
class SheepGun(Fence):
	def __init__(self,game,position):
		Fence.__init__(self,game,position,"sg_")
		self.imageOff = self.image
		self.imageOn,d = load_png( "sg_fence_on.png" )
		self.mode = 'scan'
		self.target = None
		self.decisionCounter = 0
		self.sounds = {}
		self.sounds['fire'] = load_sound('fire','gun_')
		self.sounds['beep'] = load_sound('beep','gun_')

	#----------------------------------------------------------------------
	def update(self):

		hitbox = self.rect.inflate( 80, 80 )
		if self.mode == 'scan':
			sheeps = self.game.sheepGroup
			collider = sheeps.GetFirstSpriteThatCollides( hitbox )
			if collider is not None:
				print "AQUIRED TARGET"
				self.mode = 'targetting'
				self.target = collider
				self.image = self.imageOn
		elif self.mode == 'targetting':
			if self.decisionCounter % 10 == 0:
				self.sounds['beep'].play()

			self.decisionCounter = self.decisionCounter + 1
			#print "countdown: ", self.decisionCounter
			if self.decisionCounter > 50:
				print "ATTACKING"
				self.Attack()
			if not hitbox.colliderect( self.target.rect ) \
			  or self.decisionCounter > 50:
				self.decisionCounter = 0
				self.mode = 'scan'
				self.image = self.imageOff
	
	#----------------------------------------------------------------------
	def Attack( self ):
		self.sounds['fire'].play()
		if self.target:
			print "KILLING SHEEP"
			self.target.BlownAway(self)


#--------0---------0---------0---------0---------0---------0---------0---------0
class Sheep(pygame.sprite.Sprite):
	def __init__(self, game, boundingRect, owner, prefix=''):
		pygame.sprite.Sprite.__init__(self)
		self.game = game
		self.owner = owner
		self.health = 20
		self.selected = 0

		self.imageR, self.rect = load_png( prefix +'sheep_r.png' )
		self.imageL, d = load_png( prefix +'sheep_l.png' )
		self.imageRFull, d = load_png( prefix +'sheep_rf.png' )
		self.imageLFull, d = load_png( prefix +'sheep_lf.png' )
		self.imageRSel,    d = load_png( prefix +'sheep_rs.png' )
		self.imageLSel,    d = load_png( prefix +'sheep_ls.png' )
		self.imageRFullSel,   d = load_png( prefix +'sheep_rfs.png' )
		self.imageLFullSel,   d = load_png( prefix +'sheep_lfs.png' )
		#self.imageB, d = load_png( prefix +'sheep_b.png' )
		#self.imageT, d = load_png( prefix +'sheep_t.png' )
		#self.onImage,d = load_png( prefix+'sheepselected.png')
		#self.fullImage,d = load_png( prefix+'sheepfull.png')

		self.image = self.imageR

		self.sounds = {
		                'baa': load_sound( 'baa',prefix ),
		                'confirm': load_sound( 'confirm',prefix ),
		                'deny': load_sound( 'deny',prefix ),
		              }

		self.center = self.rect.center
		self.rect.inflate_ip( -10, -10 )
		self.rect.center = self.center
		self.movestate = [0,0]
		self.speed = [5,4]
		self.boundingRect = boundingRect


		self.stallCounter = 0
		self.decisionCounter = 0

		self.target = None

		self.mode = 'wander'

		self.growthRate = 20
		self.maxHealth  = 100

		self.fertile = 1
		self.dizzy = 0

	#----------------------------------------------------------------------
	def Birth(self):
		self.rect.left = 400
		self.rect.top = 90
		self.mode = 'wander'
		self.movestate = [0,0]
		self.game.RegisterSprite(self)

		self.image = self.imageR


	#----------------------------------------------------------------------
	def ChangeImage(self):
		if self.movestate[0] == 1:
			if self.health >= self.maxHealth:
				if self.selected:
					self.image = self.imageRFullSel
				else:
					self.image = self.imageRFull
			else:
				if self.selected:
					self.image = self.imageRSel
				else:
					self.image = self.imageR

		elif self.movestate[0] == -1:
			if self.health >= self.maxHealth:
				if self.selected:
					self.image = self.imageLFullSel
				else:
					self.image = self.imageLFull
			else:
				if self.selected:
					self.image = self.imageLSel
				else:
					self.image = self.imageL

	#----------------------------------------------------------------------
	def PlayWav(self, key):
		self.sounds[key].play()


	#----------------------------------------------------------------------
	def KillAllSprites(self):
		self.center = self.rect.center
		self.rect.inflate_ip( 10,10 )
		self.rect.center = self.center
		self.movestate = [0,0]
		self.kill()
		garbage.add( self )

	#----------------------------------------------------------------------
	def GetSheared(self):
		self.KillAllSprites()
		self.game.EnqueueSheep( self )
		self.owner.money = self.owner.money + self.health
		self.health = 0
		self.ChangeImage()
		
	#----------------------------------------------------------------------
	def update(self):

		if self.mode == 'stalled':
			#TODO: this is kinda dirty maybe a timer would be better
			self.stallCounter = self.stallCounter + 1
			if self.stallCounter > 100:
				self.stallCounter = 0
				self.mode = 'wander'

		grasses = self.game.grassGroup
		hitbox = self.rect.inflate( -20, -20 )
		grassCollider = grasses.GetFirstSpriteThatCollides( hitbox )
		#colliders = pygame.sprite.spritecollide( self,grasses,0)
		if self.mode == 'wander':
			if grassCollider is not None:
				self.mode = 'stalled'
				#grass = colliders.pop()
				grassCollider.TakeBite()
				if self.health < self.maxHealth:
					self.health = self.health + self.growthRate
				else:
					self.ChangeImage()
			else:
				self.decisionCounter = self.decisionCounter + 1
				if self.decisionCounter > 10:
					self.decisionCounter = 0
					if rng.randint(1,6) == 1:
					  self.movestate[0] = rng.randint(-1,1)
					  self.movestate[1] = rng.randint(-1,1)
				self.Move()
				self.ChangeImage()
		elif self.mode == 'shearing':
			hitbox = self.rect.move(0,0)
			if hitbox.colliderect( self.target.rect ):
				self.GetSheared()
			self.Move()
		elif self.mode == 'scared':
			self.speed = [10,10]
			ms = copy(self.movestate)
			#print "--"
			#print "ms ", self.movestate
			self.Move()
			#print "change? ", self.movestate != ms
			self.movestate = ms
			#print "ms ", self.movestate
			self.decisionCounter = self.decisionCounter + 1
			if self.decisionCounter > 100:
				self.speed = [5,4]
				self.decisionCounter = 0
				self.mode = 'wander'
		elif self.mode == 'blown away':
			self.speed = [10,10]
			#ms = copy(self.movestate)
			#print "--"
			#print "ms ", self.movestate
			self.Move()
			#print "change? ", self.movestate != ms
			#self.movestate = ms
			#print "ms ", self.movestate
			self.decisionCounter = self.decisionCounter + 1
			self.spin()
			print self.decisionCounter
			if self.decisionCounter > 10:
				self.movestate = [0,0]
				#self.decisionCounter = 0
				#self.mode = 'wander'
				self.KillAllSprites()

	#----------------------------------------------------------------------
	def spin(self):
		"spin the sheep image"
		original = self.image
		center = self.rect.center
		self.dizzy += 12
		if self.dizzy >= 360:
			self.dizzy = 0
			self.image = self.original
		else:
			rotate = pygame.transform.rotate
			self.image = rotate(original, self.dizzy)
		self.rect = self.image.get_rect()
		self.rect.center = center

	#----------------------------------------------------------------------
	def Move(self):
		change = map(operator.mul, self.movestate, self.speed )
		if change == [0,0]:
			return

		self.oldPos = self.rect.move( (0,0) )
		self.rect.move_ip( change )
		
		limiter = self.Blocked( )
		if limiter.top is not None:
			self.rect.top    =limiter.top
			self.movestate[1] = 1
			if limiter.topSprite:
				limiter.topSprite.Bump(self)
		if limiter.right is not None:
			self.rect.right  =limiter.right
			self.movestate[0] = -1
			if limiter.rightSprite is None:
				#Made it to the other farm!
				if self.mode != 'blown away':
					self.game.SheepEscape( self )
			elif limiter.rightSprite:
				limiter.rightSprite.Bump(self)
		if limiter.bottom is not None:
			self.rect.bottom =limiter.bottom
			self.movestate[1] = -1
			if limiter.bottomSprite:
				limiter.bottomSprite.Bump(self)
		if limiter.left is not None:
			self.rect.left   =limiter.left
			self.movestate[0] = 1
			if limiter.leftSprite:
				limiter.leftSprite.Bump(self)

	#----------------------------------------------------------------------
	def Blocked(self):
		limiter = BoundingBox()
		
		if self.rect.top    <= self.boundingRect.top:
			limiter.top    = self.boundingRect.top
		if self.rect.right  >= self.boundingRect.right:
			limiter.right  = self.boundingRect.right
		if self.rect.bottom >= self.boundingRect.bottom:
			limiter.bottom = self.boundingRect.bottom
		if self.rect.left   <= self.boundingRect.left:
			limiter.left   = self.boundingRect.left

		colliders = pygame.sprite.spritecollide( self, 
		                                       self.game.fenceGroup, 0 )

		if len(colliders) > 0:
			for sprite in colliders:

				if( limiter.top is None \
				    or sprite.rect.bottom > limiter.top ) \
				    and self.rect.top < sprite.rect.bottom \
				    and self.oldPos.top >= sprite.rect.bottom:
					limiter.top = sprite.rect.bottom
					limiter.topSprite = sprite

				if( limiter.right is None \
				    or sprite.rect.left < limiter.right ) \
				    and self.rect.right > sprite.rect.left \
				    and self.oldPos.right <= sprite.rect.left:
					limiter.right = sprite.rect.left
					limiter.rightSprite = sprite

				if( limiter.bottom is None \
				    or sprite.rect.top < limiter.bottom ) \
				    and self.rect.bottom > sprite.rect.top \
				    and self.oldPos.bottom <=sprite.rect.top:
					limiter.bottom = sprite.rect.top
					limiter.bottomSprite = sprite

				if( limiter.left is None \
				    or sprite.rect.right > limiter.left ) \
				    and self.rect.left < sprite.rect.right \
				    and self.oldPos.left >= sprite.rect.right:
					limiter.left = sprite.rect.right
					limiter.leftSprite = sprite

		return limiter

	#----------------------------------------------------------------------
	def Frighten(self, direction):
		print "  I'm frightened! "
		self.mode = 'scared'
		self.movestate = direction

	#----------------------------------------------------------------------
	def BlownAway(self, attacker):
		self.mode = 'blown away'
		self.movestate = GetMoveStateFor(self.rect,attacker.rect)
		self.movestate[0] = -1

	#----------------------------------------------------------------------
	def UserEvent(self, event, selectedSprite):
		if event.type == MOUSEBUTTONDOWN:
			clickBox = self.rect.inflate(-10,-10)
			if clickBox.collidepoint(pygame.mouse.get_pos()):
				print "I got a user event!  I am a", \
				       self.__class__
				if selectedSprite is None:
					if self.game.activePlayer is self.owner:
						self.PlayWav( 'baa' )
						self.game.SelectSprite( self )
						self.selected = 1
						self.ChangeImage()
				else:
					selectedSprite.ActOn( self )

	#----------------------------------------------------------------------
	def ActOn(self, sprite):
		print "acting on a ", sprite
		if isinstance( sprite, Door ):
			self.PlayWav( 'confirm' )
			self.mode = 'shearing'
			self.movestate = GetMoveStateFor(self.rect,sprite.rect)
			self.target = sprite
		else:
			print "I don't know what to do to a ", sprite.__class__
			self.PlayWav( 'deny' )
			self.mode = 'wander'
			self.movestate = [0,0]
		self.game.UnSelectSprite( self )
		self.selected = 0
		self.ChangeImage()
		


#--------0---------0---------0---------0---------0---------0---------0---------0
class HighYieldSheep(Sheep):
	def __init__(self, game, boundingRect, owner):
		Sheep.__init__(self,game,boundingRect,owner, 'hy_')
		self.growthRate = 25
		self.maxHealth = 250


#--------0---------0---------0---------0---------0---------0---------0---------0
class WoodEatingSheep(Sheep):
	def __init__(self, game, boundingRect, owner):
		Sheep.__init__(self,game,boundingRect,owner, 'we_')
		self.sounds['bite'] = load_sound('bite','we_')
		self.fertile = 0

	#----------------------------------------------------------------------
	def ActOn(self, sprite):
		print "acting on a ", sprite
		if isinstance( sprite, Door ):
			self.PlayWav( 'confirm' )
			self.mode = 'shearing'
			self.movestate = GetMoveStateFor(self.rect,sprite.rect)
			self.target = sprite
		elif isinstance( sprite, Fence ):
			if self.health < self.maxHealth:
				self.PlayWav( 'deny' )
				print "I need to be full grown to eat that!"
			else:
				self.PlayWav( 'confirm' )
				self.movestate = GetMoveStateFor(self.rect,sprite.rect)
				self.target = sprite
				self.mode = 'eatwood'

		else:
			self.PlayWav( 'deny' )
			print "I don't know what to do to a ", sprite.__class__
			self.mode = 'wander'
			self.movestate = [0,0]
		self.game.UnSelectSprite( self )
		self.selected = 0
		self.ChangeImage()
		

	#----------------------------------------------------------------------
	def update(self):
		Sheep.update(self)

		if self.mode == 'eatwood':
			#hitbox = self.rect.move(0,0)
			#if hitbox.colliderect( self.target.rect ):
				#self.GetSheared()
			self.Move()
		elif self.mode == 'eatwood stall':
			self.stallCounter = self.stallCounter + 1
			if self.stallCounter > 100:
				self.stallCounter = 0
				self.mode = 'eatwood'
			


	#----------------------------------------------------------------------
	def Move(self):
		change = map(operator.mul, self.movestate, self.speed )
		if change == [0,0]:
			return

		self.oldPos = self.rect.move( (0,0) )
		self.rect.move_ip( change )
		
		limiter = self.Blocked( )
		if limiter.top is not None:
			self.rect.top    =limiter.top
			self.movestate[1] = 1
			if limiter.topSprite:
				limiter.topSprite.Bump(self)
		if limiter.right is not None:
			self.rect.right  =limiter.right
			self.movestate[0] = -1
			if limiter.rightSprite is None:
				#Made it to the other farm!
				if self.mode != 'blown away':
					self.game.SheepEscape( self )
			elif limiter.rightSprite:
				limiter.rightSprite.Bump(self)
		if limiter.bottom is not None:
			self.rect.bottom =limiter.bottom
			self.movestate[1] = -1
			if limiter.bottomSprite:
				limiter.bottomSprite.Bump(self)
		if limiter.left is not None:
			self.rect.left   =limiter.left
			self.movestate[0] = 1
			if limiter.leftSprite:
				limiter.leftSprite.Bump(self)


		if self.mode == 'eatwood':
			self.target = None;
			if limiter.topSprite is not None and \
			   isinstance(limiter.topSprite, Fence):
				self.target = limiter.topSprite
			elif limiter.rightSprite is not None and \
			   isinstance(limiter.rightSprite, Fence):
				self.target = limiter.rightSprite
			elif limiter.bottomSprite is not None and \
			   isinstance(limiter.bottomSprite, Fence):
				self.target = limiter.bottomSprite
			elif limiter.leftSprite is not None and \
			   isinstance(limiter.leftSprite, Fence):
				self.target = limiter.leftSprite

			if self.target:
				self.PlayWav( 'bite' )
				self.target.TakeBite()
				self.mode = 'eatwood stall'
			
			
			
			



#--------0---------0---------0---------0---------0---------0---------0---------0
class BoundingBox:
	def __init__(self):
		self.top    = None
		self.right  = None
		self.bottom = None
		self.left   = None

		self.topSprite    = None
		self.rightSprite  = None
		self.bottomSprite = None
		self.leftSprite   = None

#--------0---------0---------0---------0---------0---------0---------0---------0
class RectSmartGroup( pygame.sprite.RenderClear ):
	def GetAllRects(self):
		rectlist = []
		for sprite in self.sprites():
			rectlist.append( sprite.rect )
		return rectlist

	def GetFirstSpriteThatCollides(self, target):
		for sprite in self.sprites():
			if sprite.rect.colliderect( target ):
				return sprite
		return None


#--------0---------0---------0---------0---------0---------0---------0---------0
def main():

	#Random Number Generator
	global rng
	rng = Random()

	pygame.init()
	screen = pygame.display.set_mode((800, 640))
	pygame.display.set_caption('Scattering Jaunty Bleaters')

	bgSurface, devnull = load_png('title.png')
	screen.blit(bgSurface, (0,0) )
	pygame.display.flip()

	twoPlayers = 0
	done = 0
	while 1:
		if done:
			break
		for event in pygame.event.get():
			if event.type == QUIT \
			  or (event.type == KEYDOWN and event.key == K_ESCAPE):
				return
			elif event.type == MOUSEBUTTONDOWN:
				if pygame.mouse.get_pos()[0] > 400:
			 		twoPlayers = 1
				done = 1

	print "TWO : ", twoPlayers


	bgSurface, devnull = load_png('backgr.png')
	screen.blit(bgSurface, (0,0) )
	pygame.display.flip()


	clock = pygame.time.Clock()

	allSprites = pygame.sprite.RenderUpdates()
	global garbage
	garbage = RectSmartGroup()

	game = SheepGame( screen, allSprites, bgSurface, twoPlayers )

	oldFPS = 0
	while 1:
		clock.tick(40)
		newFPS = int(clock.get_fps())
		if oldFPS is not newFPS:
			print "FPS: ", newFPS
			oldFPS = newFPS

		for event in pygame.event.get():
			if event.type == QUIT \
			  or (event.type == KEYDOWN and event.key == K_ESCAPE):
				return
			elif event.type == MOUSEBUTTONDOWN:
				game.UserEvent( event )

		activeGroup = game.GetActiveGroups()
		game.Tick()

		#updates
		activeGroup.update()

		#clears
		bgSurface = game.GetBackground()
		activeGroup.clear( screen, bgSurface )

		#Garbage has to be emptied each time
		garbage.clear( screen, bgSurface )
		garbageRects = garbage.GetAllRects()
		garbage.empty()


		#draws (note, order is important)
		activeGroupRects = activeGroup.draw(screen)

		pygame.display.update( activeGroupRects \
		                     + garbageRects
				     )


if __name__ == '__main__': main()
