"""
file: warten_move.py
purpose: movements for the game.

"""


"""
Need to see where the player and aliens are moving.

Track their movements in a list of postions through the map.


# add a move.
player_moves.append( (1,1) )

# get the players last move 
player_moves[-1]

# get the aliens next move.
#  not sure if aliens should move...  Can aliens fly?
alien_moves.append(



Modes.




"""

import sys
import time
from pygame.locals import *

# a map from keys to directions.
#     maybe a joystick one would be good some time later(like when I have a joystick).
key_dirs= {K_KP7   :'ul',
           K_KP8   :'u',
           K_KP9   :'ur',
           K_KP5   :'m',
           K_KP4   :'l',
           K_KP6   :'r',
           K_KP1   :'dl',
           K_KP2   :'d',
           K_KP3   :'dr'}




# list of tuples eg (0,0) representing the pos of player on the map.
#  each element is one move.
player_moves = []

# the player has a timer associated with each move.


class PlayerAi:
    """ Responsible for limiting how quickly the player can do things.

    """

    def __init__(self, walk_time, whack_time, test_time):
        """
	"""
	self.walk_timer = ATimer(walk_time)
	self.whack_timer = ATimer(whack_time)
	self.test_timer = ATimer(test_time)

	self.walk_time = walk_time
	self.whack_time = whack_time
	self.test_time = test_time


	self._debug_level = 1



    def _debug(self, x, debug_level = 0):
        """
	"""
	if self._debug_level > debug_level:
	    print x
	    sys.stdout.flush()


    def CanWalk(self):
	return self.walk_timer.Done()

    def DoWalk(self):
        if not self.walk_timer.Done():
	    self._debug("walking without a badge.")
	self.walk_timer = ATimer(self.walk_time)

    def CanTest(self):
	return self.test_timer.Done()

    def DoTest(self):
        if not self.test_timer.Done():
	    self._debug("walking without a badge.")
	self.test_timer = ATimer(self.test_time)

    def CanWhack(self):
	return self.whack_timer.Done()

    def DoWhack(self):
        if not self.whack_timer.Done():
	    self._debug("walking without a badge.")
	self.whack_timer = ATimer(self.whack_time)



	self.whack_time = whack_time
	self.test_time = test_time







class EventUser:
    """ Uses up events, and does stuff with them

        This is where all player input will be used.

    """

    def __init__(self, map, sound_man):
        """ map - a warten_map.Map instance.
	"""
	self.map = map

	self.sound_man = sound_man

        # make a copy of the map for the enemies.
	#TODO: see if the map is copies properly.
	self.enemy_map = map
	self.enemy_map.map_data = self.enemy_map.map_data * 1

	#self.player_ai = PlayerAi(walk_time =2.0, whack_time= 2.0, test_time=2.0)
	self.player_ai = PlayerAi(walk_time =1.0, whack_time= 1.0, test_time=1.0)


	self.player_pos = self.map.GetStartPos()
	self.end_pos = self.map.GetEndPos()

        # possible modes are "move", "whack", "test".
	#  start with test as it is the safest.
	self.mode = "test"

	self.alien_dead = 0
	self.dead = 0
	self.won = 0

	self._debug_level = 1





    def _debug(self, x, debug_level = 0):
        """
	"""
	if self._debug_level > debug_level:
	    print x
	    sys.stdout.flush()


    def GetPlayerPos(self):
        """
	"""
	return self.player_pos

    def SetPlayerPos(self, pos):
        """
	"""
	self.player_pos = pos



    def Take(self, event):
        """ Takes an event, and possibly does something with it.
	"""
	self.event = event

	self.CheckMode(event)



    def CheckMode(self, event):
        """ May change the mode, or react based on the mode of the event.
	    ie it will call the right function to handle the event based on the mode.
	"""

	if event.type == KEYDOWN:
	    if event.key in [K_KP0, K_8]:
		self.mode = "test"

	    elif event.key in [K_KP_PERIOD, K_9]:
		self.mode = "move"

	    elif event.key in [K_KP_ENTER, K_0]:
		self.mode = "whack"

	    elif event.key in [K_KP1, K_KP2, K_KP3, 
	                       K_KP4,        K_KP6, 
			       K_KP7, K_KP8, K_KP9]:

		if self.mode == "test":
		    self.ActMode_test(event)
		if self.mode == "move":
		    self.ActMode_move(event)
		if self.mode == "whack":
		    self.ActMode_whack(event)


    def ActMode_test(self, event):
        """
	"""
         
	# look at the direction that tested in.
	self._debug("testing :%s:" % key_dirs[event.key],1)

	map = self.map
	direction = key_dirs[event.key]
	player_pos = self.GetPlayerPos()

	self._debug("player_pos :%s:" %[player_pos],1 )

	if self.player_ai.CanTest():
	    self.player_ai.DoTest()

	    edge_dirs = map.Get_edge(player_pos)
	    self._debug("edge_dirs:%s:" %[edge_dirs] )

	    if edge_dirs.has_key(direction):
		self._debug("make 'swoosh nothing there' noise.")
		self.sound_man.Play("woosh_123")
		time.sleep(0.3)
		self.sound_man.Play("nothing_there")


	    walkable_dirs = map.Get_walkable(player_pos)
	    alien_dirs = map.Get_alien(player_pos)
	    self._debug("walkable_dirs:%s:" %[walkable_dirs] )

	    if walkable_dirs.has_key(direction):
	        if alien_dirs.has_key(direction) and not self.alien_dead:
		    self._debug("make 'my precious' sound.")
		    self.sound_man.Play("alien_precious")
                else:
		    self._debug("make 'tap tap' sound.")
		    self.sound_man.Play("heart_1")
		#time.sleep(0.3)
		#self.sound_man.Play("")



	# IFTIME:
	# if alien:
	    # make 'scary alien noise'

	# if backwards:
	    # make 'no I can't go that way! aliens will eat my baby!' sound.

        # 
        
	# 





    def ActMode_move(self, event):
        """
	"""
	self._debug("moving:%s:" % key_dirs[event.key],1)

	map = self.map
	direction = key_dirs[event.key]
	player_pos = self.GetPlayerPos()

	self._debug("player_pos :%s:" %[player_pos] ,1)

	if self.player_ai.CanWalk():
	    self.player_ai.DoWalk()


	    edge_dirs = map.Get_edge(player_pos)
	    self._debug("edge_dirs:%s:" %[edge_dirs] )

	    if edge_dirs.has_key(direction):
		self._debug("make 'ahhhhhhh, I just fell off the cliff' noise.")
		self.sound_man.Play("ahhhhh")
		self.dead = 1

	    walkable_dirs = map.Get_walkable(player_pos)
	    self._debug("walkable_dirs:%s:" %[walkable_dirs] )

	    if walkable_dirs.has_key(direction):
	        self.SetPlayerPos(walkable_dirs[direction])
		self._debug("make 'walk walk walk sound'")
		# should make that, check to see if can walk yet.
		self.sound_man.Play("walk_1")
		time.sleep(0.4)
		self.sound_man.Play("walk_1")
		time.sleep(0.4)
		self.sound_man.Play("walk_1")

		if self.GetPlayerPos() == self.end_pos:
		    self._debug("make 'make yah! finished sound'")
		    self.sound_man.Play("finish_ack_were_free")
		    time.sleep(3)
		    self.won = 1
		    #sys.exit(0)





    def ActMode_whack(self, event):
        """
	"""
	# TODO: NOTE: for this I'll need to know where the enemies are.
	#  maybe I could have a seperate map with enemies plotted on it...


	self._debug("whack :%s:" % key_dirs[event.key])

	map = self.map
	direction = key_dirs[event.key]
	player_pos = self.GetPlayerPos()

	self._debug("player_pos :%s:" %[player_pos] )

        # need to check if an alien is near.

	alien_dirs = map.Get_alien(player_pos)
	self._debug("alien_dirs:%s:" %[alien_dirs] )

	if alien_dirs.has_key(direction) and not self.alien_dead:
		self._debug("make 'whack noise..")
		self._debug("make 'alien dying noise.'")
		self.sound_man.Play("whack_up_ye_up")
		time.sleep(1.0)
		self.sound_man.Play("whack_1")
		time.sleep(1.0)
		self.sound_man.Play("alien_dying")

		self.alien_dead = 1
	else:
		self.sound_man.Play("whack_nothing_to")
	    







class ATimer:
    def __init__(self, length):
        """
	"""
	self.Start(length)
   
    def Start(self, length ):
        """
        """
	self.length = length
        self.start_time = time.time()

    def Done(self):
        """ Returns 1 if the time has elapsed. else 0
        """
        if time.time() - self.start_time > self.length:
            return 1

	return 0
       

    def Left(self):
        """ Returns the time left.  Can return negative.
        """
	raise "not implemented"








