"""
file: warten_map.py
purpose: responsible for reading the maps for the game.
  might even be responsible for events based on the maps... not sure.
   Will probably be that way for now.

"""


"""

The map image/s will represent the path along the mountain.

Each pixel represents something different which can happen.

One color for:
  path_start
  path_end
  path_edge
  path_walkable
  path_alien



To represent what each color in the map images are:
    A bunch of one pixel .png's the name is the description, 
      the color in there is the pixel.


"""


"""

data structures needed:


pixel def name -> pixel def pixel  dict.
pixel def pixel -> pixel def name  dict.

map image as a 3d array(ie [x][y] = pixel)



TODO: 
  need a way to find the start.

    get_start_pos(map_3darray)
"""





import pygame
import os
import glob

import Numeric
N = Numeric

from pygame.locals import *
import pygame.surfarray




        # search up, down, left right pixels, and the diagonals.
	#eg 
	#
	# (14,29)|(15,29)|(16,29)   (-1,-1)|(0,-1)|(1,-1)
	# -----------------------   -----------------------
	# (14,30)|(15,30)|(16,30)   (-1,0) |(0,0) |(1,0)
	# -----------------------   -----------------------
	# (14,31)|(15,31)|(16,31)   (-1,1) |(0,1) |(1,1)
	#


directions = {'up_l':(-1,-1),
              'up':(0,-1),
              'up_r':(1,-1),
              'middle':(0,0),
              'left':(-1,0),
              'right':(1,0),
              'down_l':(-1,1),
              'down':(0,1),
              'down_r':(1,1) }
# short hand version.

dirs_ = {     'ul':(-1,-1),
              'u':(0,-1),
              'ur':(1,-1),
              'm':(0,0),
              'l':(-1,0),
              'r':(1,0),
              'dl':(-1,1),
              'd':(0,1),
              'dr':(1,1) }


dirs_list = [ 'ul', 'u', 'ur', 'm', 'l', 'r', 'dl', 'd', 'dr']
mods_list = [ (-1,-1), (0,-1), (1,-1), (0,0), (-1,0), (1,0), (-1,1), (0,1), (1,1) ]


# need a func which takes a (10,12) pos and converts it into a 'l', or 'ul' direction.




# numeric version.
dirs_n = {}
surrounds_mods = N.array( mods_list )

for dir_name in dirs_list:
    k,v = dir_name, dirs_[dir_name]
    dirs_n[k] = N.array(v)


def join_dicts(a,b):
    c = {}
    for k,v in a.items():
        c[k] = v

    for k,v in b.items():
        c[k] = v

    return c

class Map:
    """ Information about the map.
    """


    def __init__(self, map_name):
        """
	"""
	self.map_name = map_name

        # load the given map.
	self.map_data = load_maps([map_name])[map_name]

        # load the pixel to meaning maps.
	pix_def_name2pix_def, pix_def2pix_def_name = load_pixel_defs()

	self.pix_def_name2pix_def = pix_def_name2pix_def

	self.pix_def2pix_def_name = pix_def2pix_def_name

	self.start_pos = None
	self.end_pos = None


	self._debug_level = 1


    def _debug(self, x, debug_level = 0):
        """
	"""
	if self._debug_level > debug_level:
	    print x

    def GetUps(self, surrounds, current_pos):
        """ Returns a list of ones above the current_pos
	"""
	return filter(lambda x, cur_pos=current_pos: x[1] < cur_pos[1], surrounds)


    def GetStartPos(self):
        """ Returns the starting position as a tuple.
	     There should be at least one start, and not more than one.
	"""
        if self.start_pos:
	    return self.start_pos
	else:
	    self.start_pos = get_start_pos(self.map_data, self.pix_def_name2pix_def['path_start'])
	    return self.start_pos

    def GetEndPos(self):
        """ Returns the ending position as a tuple.
	     There should be at least one end, and not more than one.
	"""
        if self.end_pos:
	    return self.end_pos
	else:
	    self.end_pos = get_start_pos(self.map_data, self.pix_def_name2pix_def['path_end'])
	    return self.end_pos


    def FindSurroundingPixelDefsByName(self, pixel_def_name, current_pos, get_ups = 0):
        """ pixel_def_name - eg 'path_start'.
	    current_pos - point to look at.
	    Returns a dict keyed by direction_name, valued by pixel_def
	"""
	global dirs_
	global dirs_n
	global dirs_list

	cur_pos = Numeric.array( tuple(current_pos) )
	surrounds = []
	pix_def = self.pix_def_name2pix_def[pixel_def_name]

        # keyed by direction name.
	pixel_defs = {}

	# get the pixel def from the pixel def name.
	#   NO: turn it into the appropriate array.
	#for direction in dirs_n.values():
	#    surrounds.append( direction + cur_pos  )

	surrounds = surrounds_mods + cur_pos

	# add the direction name.
	surrounds_direction_name = zip(surrounds,dirs_list)
	


	# Get the surrounding pixel defs.

	for pos, dir_name in surrounds_direction_name:
	    try:
	        if pix_def == tuple( self.map_data[pos[0], pos[1]] ):
	            pixel_defs[dir_name] = tuple(pos)
	    except:
	        self._debug("pos not found :%s:" % [pos])
	
	if get_ups:
	    return self.GetUps(pixel_defs, current_pos)
	else:
	    return pixel_defs



    def Get_walkable(self, current_pos, get_ups = 0):
	walks = self.FindSurroundingPixelDefsByName('path_walkable' , current_pos, get_ups)
	end = self.FindSurroundingPixelDefsByName('path_end' , current_pos, get_ups =0)
	alien =self.FindSurroundingPixelDefsByName('path_alien' , current_pos, get_ups =0)
	a = join_dicts(walks, end)
	b = join_dicts(a, alien)
	return b


    def Get_alien(self, current_pos, get_ups = 0):
	return self.FindSurroundingPixelDefsByName('path_alien' , current_pos, get_ups =0)

    def Get_edge(self, current_pos, get_ups = 0):
	return self.FindSurroundingPixelDefsByName('path_edge' , current_pos, get_ups =0)








# Load pixel definition images.
pixel_def_names = map(lambda x:x[len("pixel_defs")+1:-4], 
                      glob.glob(os.path.join("pixel_defs","*.png")) 
                     )

# load the map names.
map_names = map(lambda x:x[len("maps")+1:-4], 
                glob.glob(os.path.join("maps","*.png")) 
               )



def load_pixel_defs(names = pixel_def_names):
    """ load the pixel_defs, and make the 
	  pixel def name -> pixel def pixel  dict.
	  pixel def pixel -> pixel def name  dict.
	Returns [pix_def_name2pix_def, pix_def2pix_def_name]

	TODO: what should the pixel format be?  An integer?
    """

    pix_def_name2pix_def = {}
    pix_def2pix_def_name = {}

    i_manager = ImageManager('pixel_defs')
    i_manager.Load(names)

    for surf_name in names:
	pix_tup = tuple( 
	                pygame.surfarray.array3d(i_manager.GetImage(surf_name))[0][0] 
		       )
        pix_def_name2pix_def[surf_name] = pix_tup
	pix_def2pix_def_name[pix_tup] = surf_name

    return [pix_def_name2pix_def, pix_def2pix_def_name]




def load_maps(names = map_names):
    """ Returns a dict keyed by name of map, valued by a 3d array.
        names - a list of map names( pngs in the maps dir).
    """

    maps = {}

    i_manager = ImageManager('maps')
    i_manager.Load(names)


    for map_name in names:
        surf = i_manager.GetImage(map_name)
	maps[map_name] = pygame.surfarray.array3d( i_manager.GetImage(map_name) )
        
    return maps




def get_start_pos(map_3darray, start_pixel):
    """ Returns a tuple of x,y pos in the map of the start pos.
        map_3darray - 3d array of the map.
	start_pixel - pixel representing the start_pos.
    """
    for x in xrange( len(map_3darray) ):
        for y in xrange( len(map_3darray[x]) ):
	    if tuple(map_3darray[y][x]) == start_pixel:
	        return (y,x)

    raise "Start position in map not found"






class ImageManager:
    """ Controls loading images.  Note all images should be in .png format.
    """



    def __init__(self, base_dir):
        """ base_dir - directory to load images from. eg 'images'
	"""
	self.images= {}
	self._debug_level = 1
	self.base_dir = base_dir


    def _debug(self, x, debug_level = 0):
        """
	"""
	if self._debug_level > debug_level:
	    print x




    def Load(self, names):
	"""Loads images."""
        images = self.images

	for name in names:
	    if not images.has_key(name):
		fullname = os.path.join(self.base_dir, name+'.png')
		try: 
		    image = (fullname)
	            image = pygame.image.load(fullname)

		except: 
		    image = None
		    self._debug("Error loading image:%s:" % fullname)
		images[name] = image




    def GetImage(self, name):
        """ Returns an Image object for the given name.
	"""
	if not self.images.has_key(name):
	    self.Load([name])

	return self.images[name]







