#basic sprite class for game

import bisect, pygame
import farm

class Sprite(pygame.sprite.Sprite):
    def __init__(self, containers, pos):
        pygame.sprite.Sprite.__init__(self, containers)
        self.pos = list(pos)
        self.init()

    def position_rect(self, altitude=0):
        x,y = farm.farm_to_screen(self.pos)
        self.rect.midbottom = x, y - altitude

#    def __cmp__(self, x):
#        return cmp(self.pos[1], x.pos[1])




class RenderUpdatesSorted(pygame.sprite.RenderClear):
    """like RenderUpdates, but sorts on sprite.pos[1]
    plus, now handles the 'farm' rendering for the farm"""

    def clear(self, surface, bgd):
        surface_blit = surface.blit
        for plant in self.farm.allplants:
            if plant.dirty:
                plant.dirty = 0
                surface_blit(bgd, plant.rect, plant.rect)
                
        for r in self.lostsprites:
            surface_blit(bgd, r, r)
        for r in self.spritedict.values():
            if r is not 0: surface_blit(bgd, r, r)
        self.lostsprites = []


    def draw(self, surface):
        spritedict = self.spritedict
        surface_blit = surface.blit
        dirty = self.lostsprites
        self.lostsprites = []
        dirty_append = dirty.append
        plants = self.farm.allplants
        nexty = farm.farmtiley
        maxplants = len(plants)
        nextindex = 0
        sprites = spritedict.items()
        sprites.sort(lambda x,y:cmp(x[0].pos[1], y[0].pos[1]))
        for s, r in sprites:
            while s.pos[1] > nexty and nexty < maxplants:
                for x in range(nextindex, nextindex+9):
                    p = plants[x]
                    surface_blit(p.image, p.rect)
                nexty += farm.farmtiley
                nextindex += 9
            newrect = surface_blit(s.image, s.rect)
            if r is 0:
                dirty_append(newrect)
            else:
                dirty_append(newrect.union(r))
            spritedict[s] = newrect
        for p in plants[nextindex:]:
            surface_blit(p.image, p.rect)
        return dirty





class GroupSingleDestroy:
    """like regular groupsingle, but kills sprite when it
    is replaced from this group"""
    _spritegroup = 1 #dummy val to identify groups

    def __init__(self, sprite=()):
        self.sprite = 0
        self.add(sprite)

    def copy(self):
        if self.sprite is not 0:
            return GroupSingle(self.sprite)
        return GroupSingle()

    def sprites(self):
        if self.sprite is not 0:
            return [self.sprite]
        return []

    def add(self, sprite):
        if hasattr(sprite, '_spritegroup'):
            for sprite in sprite.sprites(): pass
        else:
            try:
                if not len(sprite): return #see if its a sequence
                sprite = sprite[-1]
            except (TypeError, AttributeError): pass
        if sprite is not self.sprite:
            self.add_internal(sprite)
            sprite.add_internal(self)

    def remove(self, sprite):
        if hasattr(sprite, '_spritegroup'):
            for sprite in sprite.sprites():
                if self.sprite is sprite:
                    self.sprite = 0
                    sprite.remove_internal(self)
                    break
        else:
            try:
                if not len(sprite): return #see if its a sequence
            except (TypeError, AttributeError):
                if self.sprite is sprite:
                    self.sprite = 0
                    sprite.remove_internal(self)
            else:
                for sprite in sprite:
                    if self.sprite is sprite:
                        self.sprite = 0
                        sprite.remove_internal(self)
                        break

    def add_internal(self, sprite):
        if self.sprite is not 0:
            self.sprite.kill() #here's the "big" change
        self.sprite = sprite

    def remove_internal(self, sprite):
        self.sprite = 0

    def has(self, sprite):
        return self.sprite is sprite

    def empty(self):
        if self.sprite is not 0:
            self.sprite.kill()

    def update(self, *args):
        if self.sprite:
            apply(self.sprite.update(args))

    def __nonzero__(self):
        return self.sprite is not 0

    def __len__(self):
        return self.sprite is not 0

    def __repr__(self):
        return "<%s(%d sprites)>" % (self.__class__.__name__, len(self))
