#sprites for the player

import pygame
import sprite, ticker

images = ['target', 'scaredance', 'scarewalk']

class Target(sprite.Sprite):
    def init(self):
        self.image = images.target
        self.image.set_colorkey(self.image.get_at((0,0)), pygame.RLEACCEL)
        self.rect = self.image.get_rect()
        self.position_rect()
        self.target = 0

    def update(self, time, game):
        #some sort of anim would be nice
        pass

danceanim = []
leftanim = []
rightanim = []
walkanims = [leftanim, rightanim]

def create_anims():
    global crowanims
    all = images.scaredance
    for x in range(0, all.get_width(), 80):
        img = pygame.Surface((80, all.get_height()))
        img.blit(all, (0,0), (x, 0, 80, all.get_height()))
        img.set_colorkey(img.get_at((0,0)), pygame.RLEACCEL)
        danceanim.append(img)
    for i in danceanim[:]:
        danceanim.append(pygame.transform.flip(i, 1, 0))

    all = images.scarewalk        
    for x in range(0, all.get_width(), 80)[:4]:
        img = pygame.Surface((80, all.get_height()))
        img.blit(all, (0,0), (x, 0, 80, all.get_height()))
        img.set_colorkey(img.get_at((0,0)), pygame.RLEACCEL)
        rightanim.append(img)
        leftanim.append(pygame.transform.flip(img, 1, 0))
    walkanims.append(leftanim[-1])
    leftanim[-1] = leftanim[1]
    rightanim[-1] = rightanim[2]



class Player(sprite.Sprite):
    def init(self):
        if not danceanim:
            create_anims()
        self.target = sprite.GroupSingleDestroy()
        self.startwalk = self.pos
        self.startwalktime = 0
        self.image = danceanim[0]
        self.rect = self.image.get_rect()
        self.position_rect()
        self.health = 100
        self.ticker = ticker.Ticker(5000)
        self.update = self.update_stand
        self.cantmovemodes = self.update_dead, self.update_stuck
        self.animticker = ticker.Ticker(1000, 0, 10, ticker.looping)
        self.dontdance = 1


    def newtarget(self, pos):
        if self.update in self.cantmovemodes: return
        self.ticker = ticker.TickerSpeed(.1, self.pos, pos)
        self.anim = walkanims[self.pos[0] < pos[0]]
        self.update = self.update_walk

    def checkdead(self):
        if self.health < 1:
            self.ticker = ticker.Ticker(8000)
            self.update = self.update_dead
            self.image = walkanims[-1]
        
    def update_walk(self, time, game):
        self.checkdead()
        if self.ticker:
            self.pos = self.ticker.tick(time)
            f = self.animticker.tick(time)
            self.image = self.anim[int(f) % len(self.anim)]
            self.position_rect()
        else:
            self.ticker = ticker.Ticker(1000)
            self.update = self.update_stand

    def update_dead(self, time, game):
        if self.ticker:
            self.ticker.tick(time)
        else:
            self.ticker = ticker.Ticker(3000)
            self.update = self.update_stand
            self.image = danceanim[0]
            self.health = 100

    def update_stand(self, time, game):
        self.checkdead()
        if self.ticker:
            self.ticker.tick(time)
        else:
            if not self.dontdance:
                self.ticker = ticker.Ticker(9000, 0, 50, ticker.looping)
                self.update = self.update = self.update_dance
                self.anim = danceanim

    def update_dance(self, time, game):
        self.checkdead()
        if self.ticker:
            f = self.ticker.tick(time)
            self.image = self.anim[int(f) % len(self.anim)]
        else:
            self.ticker = ticker.Ticker(1000)
            self.update = self.update = self.update_stand
            self.image = self.anim[0]

    def getstuck(self):
        self.ticker = ticker.Ticker(1000)
        self.update = self.update_stuck

    def update_stuck(self, time, game):
        self.checkdead()
        if self.ticker:
            self.ticker.tick(time)
        else:
            self.ticker = ticker.Ticker(3000)
            self.update = self.update_stand
