#sprites for the player

import pygame, random
import sprite, ticker, farm

images = ['crowsprites', 'danger']


crowanims = [{}, {}]

def create_crowanims():
    global crowanims
    all = images.crowsprites
    l_imgs = []
    r_imgs = []
    for x in range(0, all.get_width(), 50):
        img = pygame.Surface((50, all.get_height()))
        img.blit(all, (0,0), (x, 0, 50, all.get_height()))
        img.set_colorkey(img.get_at((0,0)), pygame.RLEACCEL)
        l_imgs.append(img)
        r_imgs.append(pygame.transform.flip(img, 1, 0))
    crowanims[0]['walk'] = l_imgs[0], l_imgs[1]
    crowanims[0]['peck'] = l_imgs[2], l_imgs[3]
    crowanims[0]['fly'] = l_imgs[4], l_imgs[5]    
    crowanims[0]['launch'] = l_imgs[6], l_imgs[6]
    
    crowanims[1]['walk'] = r_imgs[0], r_imgs[1]
    crowanims[1]['peck'] = r_imgs[2], r_imgs[3]
    crowanims[1]['fly'] = r_imgs[4], r_imgs[5]    
    crowanims[1]['launch'] = r_imgs[6], r_imgs[6]    

def newcrow(groups):
    x = (-200, 840)[random.randint(0,1)]
    y = random.randint(100, 220)
    return Crow(groups, (x,y))

class Crow(sprite.Sprite):
    def init(self):
        if not crowanims[0]:
            create_crowanims()
        self.target = sprite.GroupSingleDestroy()
        self.altitude = 1
        self.update = self.update_walk
        self.target = None
        self.danger = None #for plotting evil
        self.attacking = 0 #onground pecking attack
        self.anim = crowanims[0]
        self.image = self.anim['walk'][0]
        self.rect = self.image.get_rect()
        self.startflying('food', None)

    def flee(self, game):
        r = random.random()
        if r < .45:
            self.startflying('leave', game)
        if r < .9:
            self.startflying('flee', game)

    def startflying(self, target, game):
        dest = None
        if self.danger:
            self.danger.delcrow()
            self.danger = None
        self.target = target
        if target == 'leave':
            if self.pos[0] < 250: dest = -200, 300
            else: dest = 840, 300
        elif target == 'food':
            x = random.random() * farm.farmwidth
            y = random.random() * farm.farmheight
            dest = x, y
        elif target == 'flee':
            x = (random.random()-.5) * 200
            y = (random.random()-.5) * 120
            if x>0: x += self.pos[0] + 30
            else: x += self.pos[0] - 100
            if y>0: y += self.pos[1] + 30
            else: y += self.pos[1] - 100
            dest = farm.farm_clamp((x,y))
        elif target == 'attack':
            x,y = game.player.pos
            x += (random.random()-.5) * 40
            y += (random.random()-.5) * 40
            dest = x,y
        if dest:
            if self.altitude:
                start = self.pos[0], self.pos[1], self.altitude
                end = dest[0], dest[1], 0
                self.ticker = ticker.TickerBird(.1, start, end)
                self.update = self.update_fly
            else:
                self.ticker = ticker.Ticker(random.randint(250, 400))
                self.update = self.update_launching
                self.altitude = 1
            self.anim = crowanims[dest[0] < self.pos[0]]
            self.dest = dest
        else:
            self.update = self.update_startwalk

    def update_launching(self, time, game):
        if self.ticker:
            self.ticker.tick(time)
            self.image = self.anim['launch'][0]
        else:
            start = self.pos[0], self.pos[1], 0
            end = self.dest[0], self.dest[1], 0
            self.ticker = ticker.TickerBird(.2, start, end)
            self.update = self.update_fly

    def startwalking(self):
        x = (random.random()-.5) * 80 + self.pos[0]
        y = (random.random()-.5) * 60 + self.pos[1]
        self.anim = crowanims[x < self.pos[0]]
        dest = farm.farm_clamp((x,y))
        self.ticker = ticker.TickerSpeed(.02, self.pos, dest)
        self.update = self.update_walk
            
    def update_walk(self, time, game):
        if self.ticker:
            self.pos = self.ticker.tick(time)
            f = int((self.ticker.percent*9) % 2)
            self.image = self.anim['walk'][f]
            self.position_rect()
        else:
            self.landed(game)

    def update_fly(self, time, game):
        if self.ticker:
            x,y,a = self.ticker.tick(time)
            self.pos = x, y
            self.altitude = a
            self.image = self.anim['fly'][int((a/6)%2)]
            self.position_rect(a)
        else:
            self.landed(game)

    def landed(self, game):
        self.altitude = 0
        if self.target == 'leave':
            self.kill()
        elif self.target == 'attack':
            self.startattackpeck()
            game.player.health -= 10
        ppos = game.player.pos
        pdist = (ppos[0]-self.pos[0])**2 + (ppos[1]-self.pos[1])**2
        if pdist < 1600.0:
            self.startattackpeck()
            game.player.health -= 10
        else:
            self.starteating()
        #find neighbors, start some danger?
        if not game.lastattackticker:
            nearcrows = game.nearcrows(self.pos, 40, self)
            if nearcrows:
                danger = None
                for crow in nearcrows:
                    if crow.danger: danger = crow.danger
                if not danger:
                    danger = Danger(game.allsprites, self.pos)
                self.danger = danger
                danger.addcrow()
                for crow in nearcrows:
                    if crow.danger and crow.danger is not danger:
                        crow.danger = danger
                        danger.addcrow()

    def startattackpeck(self): #peckpeck
        self.attacking = 1
        self.ticker = ticker.Ticker(random.randint(600, 1000), 0, 100)
        self.update = self.update_eat
        self.plant = None

    def starteating(self): #peckpeck
        self.ticker = ticker.Ticker(random.randint(1200, 2500), 0, 15)
        self.update = self.update_eat
        self.anim = crowanims[random.randint(0,1)]
        self.plant = farm.thefarm.get(self.pos)

    def update_eat(self, time, game):
        if self.ticker:
            f = self.ticker.tick(time)
            self.image = self.anim['peck'][int(f)%2]
        else:
            if self.plant:
                self.plant.damage(18)
                self.plant = None
            self.dorandom(game)

    def dorandom(self, game):
        if self.attacking:
            self.attacking = 0
            self.startflying('food', game)
        elif not self.danger:
            r = random.random()
            if r < .16: self.starteating()
            elif r < .7: self.startwalking()
            elif r < .9: self.startflying('food', game)
            else: self.startflying('leave', game)
        else:
            r = random.random()
            if r < .4: self.starteating()
            else: self.startwalking()


class Danger(sprite.Sprite):
    dangersprites = pygame.sprite.Group()
    def init(self):
        self.level = 0
        self.ticker = ticker.Ticker(3000, 0, 100)
        Danger.dangersprites.add(self)
        self.image = images.danger
        self.rect = self.image.get_rect()
        self.position_rect(10)
        self.image.set_colorkey(self.image.get_at((0,0)), pygame.RLEACCEL)
        self.numcrows = 0

    def addcrow(self):
        self.numcrows += 1

    def delcrow(self):
        self.numcrows -= 1
        if self.numcrows < 2:
            self.kill()

    def update(self, time, game):
        if self.ticker:
            self.level = int(self.ticker.tick(time * (self.numcrows-1)))
        else:
            game.lastattackticker = ticker.Ticker(10000)
            for crow in game.allcrows.sprites():
                crow.startflying('attack', game)
                crow.danger = None
                game.player.getstuck()
            Danger.dangersprites.empty()
