#play class for the title screen

import pygame
from pygame.locals import *

import playgame


##resources

images = ['title',
          'btn_easy_off', 'btn_easy_on',
          'btn_normal_off', 'btn_normal_on',
          'btn_hard_off', 'btn_hard_on',
          'btn_quit_off', 'btn_quit_on']



messages = """




Go Scarecrow, Go!
Developed by
Pete Shinners

This is my _exciting_
entry for the 48-hour
Ludum Dare game contest.

It was developed in
python, using the
excellent pygame package
http://www.pygame.org

Protect the farmer's
crops from swarms of evil
crows. You can chase the
crows around to keep them
off of the plants.

Your game is over if you
run out of plants.

If you hold still, the
scarecrow will dance, which
really seems to frighten
the birds.

If too many birds gather
together, they will order
an attack, and all birds
will join forces to eat
you.




"""

##code

class Play:
    def __init__(self):
    	self.nextmode = None
	self.Update = self.FirstUpdate
	self.rendermessage()
	self.starttime = None
        self.menu = [
                [images.btn_easy_off, images.btn_easy_on, (5,)],
                [images.btn_normal_off, images.btn_normal_on, (7,)],
                [images.btn_hard_off, images.btn_hard_on, (9,)],
                 None,
                [images.btn_quit_off, images.btn_quit_on, None],
               ]
        x, y = 25, 205
        for m in self.menu:
            if m:
                r = m[0].get_rect().move(x,y)
                m[0].set_colorkey(m[0].get_at((0,0)), pygame.RLEACCEL)
                m[1].set_colorkey(m[1].get_at((0,0)), pygame.RLEACCEL)
                m.append(r)
            y += 50
        self.over = None


    def HandleEvent(self, e):   #handle an event
    	if e.type == MOUSEBUTTONDOWN:
	    if self.over:
                result = self.over[-2]
                if not result:
                    self.nextmode = -1
                else:
                    self.nextmode = playgame.Play(result[0])
	if e.type == KEYDOWN:
	    if e.key == K_ESCAPE:
	    	self.nextmode = -1
	elif e.type == MOUSEMOTION:
            for m in self.menu:
                if m:
                    if m[-1].collidepoint(e.pos):
                        self.over = m
                        break


    def GetNextMode(self): #next mode, None=nochange, -1=quit
    	return self.nextmode


    def FirstUpdate(self, screen, time): #only called first draw
    	r = screen.blit(images.title, (0,0))
	self.Update = self.RealUpdate
	return r


    def RealUpdate(self, screen, time):
    	r = self.drawmessage(screen)
    	dirty = [r]
    	for m in self.menu:
            if m:
                index = m is self.over
                r = screen.blit(m[index], m[-1])
                dirty.append(r)
    	return [r]

    def drawmessage(self, screen):
        r = screen.blit(images.title, self.msgrect, self.msgrect)
        screen.set_clip(self.msgrect)

        if not self.starttime:
            self.starttime = pygame.time.get_ticks()
        runline = int((pygame.time.get_ticks() - self.starttime) * .02)
        pixeloffset = runline % self.msgheight
        for x in range(self.showlines):
            i = ((runline / self.msgheight) + x) % len(self.text)
            line, rect = self.text[i]
            if not line: continue
            top = self.msgrect.top - pixeloffset + x * self.msgheight
            rect.midtop = self.msgrect.centerx, top
            screen.blit(line, rect)
        screen.set_clip()
        return r

    def rendermessage(self):
    	font = pygame.font.Font(None, 20)
	self.msgheight = font.get_height()
	self.msgrect = pygame.Rect(425, 247, 175, 188)
	self.showlines = 11
	self.text = []
	fore, back = (255,255,0), (0,0,0)
    	for m in messages.split('\n'):
	    if m:
	    	line = font.render(m, 0, fore)#, back)
	    	#line.set_colorkey(back, pygame.RLEACCEL)
		self.text.append((line.convert(), line.get_rect()))
	    else:
	    	self.text.append((None, None))

	




