#play class for the actual game

import pygame, random
from pygame.locals import *

import farm, playtitle, playend
import sprite, s_player, s_crow, ticker


##resources

thegame = None
images = ['gamefield', 'sun', 'skyline', 'night']

##code

class Play:
    def __init__(self, totaldays=5):
    	self.nextmode = None
	self.Update = self.FirstUpdate
	self.totaldays = totaldays
	self.daysplayed = 0
	self.allsprites = sprite.RenderUpdatesSorted()
	self.allcrows = pygame.sprite.Group()
	self.player = None
        self.farm = farm.Farm()
        self.farm.plantfarm()
        self.farm.growplants(18)
        self.bgd = self.farm.renderroads(images.gamefield)
        self.skymatte = images.skyline
        self.skymatte.set_colorkey(0, pygame.RLEACCEL)
        self.sun = images.sun
        self.sun.set_colorkey(self.sun.get_at((0,0)), pygame.RLEACCEL)
        self.blanksky = pygame.Surface((640, 64))
        self.blanksky.set_colorkey((255,255,255))
	self.allsprites.farm = self.farm
	self.nightsky = images.night
	self.nightsky.set_colorkey((255,255,255), pygame.RLEACCEL)
	global thegame
	thegame = self
	

    def rendersky(self, sunpos, screen):
        if self.oldsunpos != sunpos:
            self.oldsunpos = sunpos
            alt = sunpos[2] / 3
            pos = sunpos[0], sunpos[1] - alt
            self.blanksky.fill((255 - alt*3, 156, 200))
            self.blanksky.blit(self.sun, pos)
            self.blanksky.blit(self.skymatte, (0,0))
            return screen.blit(self.blanksky, (0,0))
        return None

    def HandleEvent(self, e):   #handle an event
    	if e.type == MOUSEBUTTONDOWN:
	    if e.button == 1:
                self.newtarget(e.pos)
	if e.type == KEYDOWN:
	    if e.key == K_ESCAPE:
	    	self.nextmode = playtitle.Play()
	    elif e.key == K_UP:
                self.farm.growplants(7)
            elif e.key == K_SPACE:
                s_crow.newcrow((self.allsprites, self.allcrows))


    def GetNextMode(self): #next mode, None=nochange, -1=quit
    	return self.nextmode

    def newtarget(self, pos):
        offpos = pos[0]+2, pos[1]+11
        farmpos = farm.screen_to_farm_clamp(offpos)
        #c = self.allsprites, self.player.target
        #target = s_player.Target(c, farmpos)
        self.player.newtarget(farmpos)
        plant = self.farm.get(farmpos)
        #if not plant: print 'DIRTPATH'
        #else: print 'PLANT HEALTH:', plant.health, plant.anim.index(plant.image)

    def nearcrows(self, (x,y), radius, ignore=None):
        radius **= 2
        near = []
        for c in self.allcrows.sprites():
            if c is ignore: continue
            if c.altitude or c.attacking: continue
            dist = ((x-c.pos[0]))**2 + ((y-c.pos[1])**2)
            if dist < radius:
                near.append(c)
        return near

    def FirstUpdate(self, screen, time): #only called first draw        
    	r = screen.blit(images.gamefield, (0,0))
        self.player = s_player.Player(self.allsprites, (250, 170))
        self.StartNight(screen)
	return r

    def NormalUpdate(self, screen, time):
        self.allsprites.clear(screen, self.bgd)

        if random.random() < .0018*time or not self.allcrows:
            s_crow.newcrow((self.allsprites, self.allcrows))
        
        scary = 80
        if self.player.update == self.player.update_dance:
            scary = 300
        for crow in self.nearcrows(self.player.pos, scary):
            crow.flee(self)
        if self.lastattackticker:
            self.lastattackticker.tick(time)
            
        sunpos = self.levelticker.tick(time)
        skydirt = self.rendersky(sunpos, screen)
        if not self.levelticker:
            for crow in self.allcrows.sprites():
                crow.startflying('leave', self)
            self.Update = self.EndUpdate
            self.player.dontdance = 1
        self.allsprites.update(time, self)
        dirty = self.allsprites.draw(screen)
        dirty.append(skydirt)
        
        return dirty
    

    def EndUpdate(self, screen, time):
        self.allsprites.clear(screen, self.bgd)
        self.allsprites.update(time, self)
        dirty = self.allsprites.draw(screen)

        if not self.allcrows:
            self.StartNight(screen)

        return dirty


    def StartNight(self, screen):
        anyplants = 0
        for p in self.farm.allplants:
            if p.health > 2:
                anyplants = 1
                break
        if not anyplants:
            self.nextmode = playend.Play(0)
        
        d = screen.blit(self.nightsky, (0,0))
        self.levelticker = ticker.Ticker(3000, 0, 10)
        self.Update = self.UpdateNight
        self.player.health = 100
        self.grown = 0
        self.totaldays -= 1
        if not self.totaldays:
            self.nextmode = playend.Play(1)

    def UpdateNight(self, screen, time):
        t = self.levelticker.tick(time)
        self.allsprites.clear(screen, self.bgd)
        self.allsprites.update(time, self)
        while self.grown < t:
            self.grown += 1
            self.farm.growplants(2)
        dirty = self.allsprites.draw(screen)
        
        if not self.levelticker:
            self.levelticker = ticker.TickerBird(.016, (0, 10, 0), (640, 10, 0))
            self.lastattackticker = None
            self.oldsunpos = None
            self.Update = self.NormalUpdate
            self.player.dontdance = 0
            self.player.ticker = ticker.Ticker(5000)
            self.player.update = self.player.update_stand
        return dirty
