#main entry and loop for the game

import sys, os
import pygame
from pygame.locals import *

import playtitle as firstplaymode
#import playgame as firstplaymode

import gfxcursor, transition


def rungame():
    pygame.init()

    #setup screen
    res = 640, 480
    flags = 0 #|FULLSCREEN
    depth = pygame.display.mode_ok(res, flags, 16)
    screen = pygame.display.set_mode(res, flags, depth)
    pygame.display.set_caption('Go, Go, Scarecrow!', 'scarecrow')

    n = os.path.join('gfx', 'loading.png')
    screen.blit(pygame.image.load(n), (0,0))
    pygame.display.update()
    preload()

    mode = firstplaymode.Play()
    cursor = gfxcursor.Cursor()

    transition.vertwipe(screen, mode)

    clock = pygame.time.Clock()
    clockticked = 0
    while 1:
        #handle input
        for e in pygame.event.get():
            if e.type == QUIT:
                return
            mode.HandleEvent(e)

        #update and draw
        dirty = mode.Update(screen, clockticked)
        dirty.append(cursor.Draw(screen))
        #pygame.display.update(dirty)
        pygame.display.flip()
        cursor.Clear(screen)

        #mode switches
        newmode = mode.GetNextMode()
        if newmode == -1:
            return
        if newmode:
            oldmode = mode
            mode = newmode
            transition.vertwipe(screen, mode)
        
        clockticked = clock.tick(50)


def preload():
    modules = ['playtitle', 'playgame', 'playend', 's_player', 's_crow', 'farm']
    class Empty: pass
    for name in modules:
        mod = __import__(name)
        if hasattr(mod, 'images'):
            images = mod.images
            newimages = Empty()
            for i in images:
                fullname = os.path.join('gfx', i + '.png')
                img = pygame.image.load(fullname).convert()
                setattr(newimages, i, img)
            mod.images = newimages
        if hasattr(mod, 'sounds'):
            print 'Loading Sounds For:', name
            sounds = mod.sounds
            newsounds = Empty()
            for s in sounds:
                fullname = os.path.join('snd', s + '.wav')
                img = pygame.mixer.Sound(fullname)
                newsounds(newimages, img)
            mod.sounds = newsounds
        
