#farm routines


import random, pygame
import sprite

images = ['plant1']


farmleft, farmtop = 135, 110
farmwidth, farmheight = 499, 359
farmtilex, farmtiley = 50, 36
farmskew = 0.35

thefarm = None

def farm_clamp((mx, my)):
    return max(0, min(mx, farmwidth)), max(0, min(my, farmheight))

def farm_to_screen((mx, my)):
    return mx + farmleft - int(farmskew * my), my+farmtop

def screen_to_farm((sx,sy)):
    y = sy - farmtop
    return sx - farmleft + int(farmskew * y), y
    
def screen_to_farm_clamp(pos):
    return farm_clamp(screen_to_farm(pos))
    


class Farm:
    def __init__(self):
        self.data = {}
        self.allplants = []
        global thefarm
        thefarm = self

    def get(self, pos):
        x,y = int(pos[0]), int(pos[1])
        try:
            return self.data[x/farmtilex, y/farmtiley]
        except KeyError:
            return None

    def plantfarm(self):
        self.horzroad = random.randint(3,7)
        self.vertroad = random.randint(3,7)
        anims = {
            (0,0): (create_plantanim('plant'+str(random.randint(1,1)), 0),
                   create_plantanim('plant'+str(random.randint(1,1)), 1)),
            (0,1): (create_plantanim('plant'+str(random.randint(1,1)), 0),
                   create_plantanim('plant'+str(random.randint(1,1)), 1)),
            (1,0): (create_plantanim('plant'+str(random.randint(1,1)), 0),
                   create_plantanim('plant'+str(random.randint(1,1)), 1)),
            (1,1): (create_plantanim('plant'+str(random.randint(1,1)), 0),
                   create_plantanim('plant'+str(random.randint(1,1)), 1)),
        }
        for y in range(10):
            for x in range(10):
                if x==self.vertroad or y==self.horzroad:
                    p = None
                else:
                    corner = x<self.vertroad, y<self.horzroad
                    p = Plant((x,y), anims[corner][random.randint(0,1)])
                    self.allplants.append(p)
                self.data[x,y] = p
        #need to render a background plate with roads rendered

    def growplants(self, factor):
        for p in self.allplants:
            if p: p.grow(factor)

    def renderroads(self, image): #render roads onto an image
        return image


def create_plantanim(name, flipped):
    anim = []
    all = getattr(images, name)
    img = pygame.Surface((50, all.get_height()))
    img.set_colorkey(img.get_at((0,0)), pygame.RLEACCEL)
    anim.append(img)
    for x in range(0, all.get_width(), 50):
        img = pygame.Surface((50, all.get_height()))
        img.blit(all, (0,0), (x, 0, 50, all.get_height()))
        if flipped:
            img = pygame.transform.flip(img, 1, 0)
        img.set_colorkey(img.get_at((0,0)), pygame.RLEACCEL)
        anim.append(img)
    return anim


class Plant:
    def __init__(self, pos, anim):
        self.health = 0
        self.dirty = 0
        self.anim = anim
        self.image = self.anim[0]
        self.rect = anim[1].get_rect()
        x = pos[0] * farmtilex + farmtilex / 2 + random.randint(-2,2)
        y = (pos[1]+1) * farmtiley +  random.randint(-2,2)
        self.rect.midbottom = farm_to_screen((x,y))

    def grow(self, amount):
        self.health += int(amount * (random.random() * .5 + .75))
        self.health = min(self.health, 100)
        oldimg = self.image
        self.image = self.anim[int((self.health+10)/30)]
        if oldimg is not self.image: self.dirty = 1

    def damage(self, amount):
        self.health -= int(amount * (random.random() * .5 + .75))
        self.health = max(self.health, 0)
        oldimg = self.image
        self.image = self.anim[int((self.health+10)/30)]
        if oldimg is not self.image: self.dirty = 1
        
#    def __cmp__(self, x):
#        return cmp(self.pos[1], x.pos[1])
