"""This class controls the behaviour of the evil-enterprise"""

import math
import random #this may not be entirely acceptable in an AI thing ;)
import pygame 

LEFT  = 0
RIGHT = 1
BGD   = 8
UP    = -1
DOWN  = 1

from missile import missile

class evil_enterprise:
    def __init__(self, missiles, speed, imgs):
	"""position is randomly generated but outside the viewing area at the beginning,
	   missiles is the number of missiles the ship carries, speed is the speed of the ships
	   and the missiles"""
	self.imgs = imgs
	self.timer = 0
	self.speed = speed   #missile speed is the same as ship speed (lazy I know)
	self.num_missiles = missiles
	window = 900 / missiles
	self.firing_times = []
	for i in range(1, self.num_missiles + 2):
	    self.firing_times.append(random.randrange(window*i, i* (window +1)))
	self.scr = pygame.display.get_surface()
	if random.randrange(0,2): #start off from the right
	    self.img = LEFT
	    self.dir = -1
	    self.rect = pygame.Rect((920, random.randrange(30, 570), 100, 30))
	else:
	    self.img = RIGHT
	    self.dir = 1
	    self.rect = pygame.Rect((-120, random.randrange(30, 570), 100, 30))	    
	self.missiles = []
	self.targeting()

    def hide(self):
       	upds = []
	for MrIle in self.missiles:  # calling it MissIle is sexist ... 
	    upds.append(MrIle.hide())
	upds.append(self.scr.blit(self.imgs[BGD], self.rect, self.rect))
	return upds

    def draw(self):
	#first of all check whether to launch a missile or not
	self.timer += 1
	upds = []
	if self.num_missiles:
	    if self.timer > self.firing_times[0]:
		self.fire_missile()
		self.firing_times = self.firing_times[1:]
		self.num_missiles -= 1
	self.rect.move_ip(self.x_mov, self.y_mov)
	if self.rect.colliderect(self.target): #weve reached the target area
	    self.targeting()
	for MrIle in self.missiles:
	    upds.append(MrIle.draw())
	upds.append(self.scr.blit(self.imgs[self.img], self.rect))
	return upds

    def get_rects(self):
	ret = []
	for mil in self.missiles:
	    ret.append(mil.get_rect())
	return ret

    def is_missile(self, rect):
	for mil in self.missiles:
	    if rect.colliderect(mil.get_rect()):
		return 1

    def kill_missile(self, rect):
	for mil in self.missiles:
	    if rect.colliderect(mil.get_rect()):
		self.missiles.remove(mil)
		return mil.die()

    def fire_missile(self):
	position = [self.rect.left + 50, self.rect.top + 30]
	self.missiles.append(missile(position, self.imgs, self.speed))
	
    def missiles_left(self):
	return self.missiles or self.num_missiles #say we have some left if there in the air

    def bug_out(self): # retreat for resupply
	if self.rect.left < 400: # we're closer to the left
	    self.dir = -1
	    self.target = pygame.Rect((-120, self.target.left, 1, 1))
	else:
	    self.dir = 1
	    self.target = pygame.Rect((920, self.target.left, 1, 1))

    def targeting(self):
	#generate target coords
	x, y = self.rect.left, self.rect.top
	if x < 350 and y < 250:
	    dir = random.randrange(0,2)
	    if dir: 
		xrange = [550, 750]
		yrange = [40, 150]
	    else:
		xrange = [0, 200]
		yrange = [450, 570]
	elif x < 350 and y > 350:
	    dir = random.randrange(0, 2)
	    if dir: 
		xrange = [550, 750]
		yrange = [450, 570]
	    else:
		xrange = [0, 200]
		yrange = [40, 150]
	elif x > 450 and y < 250:
	    dir = random.randrange(0, 2)
	    if dir:
		xrange = [0, 200]
		yrange = [40, 150]
	    else:
		xrange = [550, 750]
		yrange = [450, 570]
	elif x > 450 and y > 350:
	    dir = random.randrange(0, 2)
	    if dir:
		xrange = [0, 200]
		yrange = [450, 570]
	    else:
		xrange = [550, 750]
		yrange = [40, 150]
	elif x in range(340, 460):
	    xrange = [0, 200]
	    if y < 300:
		yrange = [40, 150]
	    else:
		yrange = [450, 570]
	elif y in range(240, 360):
	    yrange = [450, 570]
	    if x < 400:
		xrange = [0, 200]
	    else:
		xrange = [550, 750]
	else: # oops shouldn't get here, but just in case
	    xrange = [x, y + 10]
	    yrange = [x, y + 10]
       	self.target = pygame.Rect((random.randrange(xrange[0], xrange[1]),
				   random.randrange(yrange[0], yrange[1]), 1, 1))
	xdis = self.target.left - self.rect.left
	ydis = self.target.top - self.rect.top
	steps = int(math.sqrt(xdis * xdis + ydis * ydis) / self.speed)
	if xdis < 0: # were moving left
	    self.dir = -1
	    self.img = LEFT
	    xdis = -xdis 
	else:
	    self.dir = 1
	    self.img = RIGHT

	if ydis < 0:
	    ydis = -ydis
	    self.dir_y = UP
	else:
	    self.dir_y = DOWN
	self.x_mov = self.dir * (xdis / steps)
	self.y_mov = self.dir_y * (ydis / steps)
	self.target.left = self.rect.left + self.x_mov * steps
	self.target.top = self.rect.top + self.y_mov * steps

	
	
