"""game.py, glues all the other stuff together"""
#python stuff
try: 
    import os, sys
except ImportError:
    print "There is an error with your python installation"
    print "the standard modules os and sys are not available."
    raise SystemExit
    
#pygame stuff
try:    
    import pygame, pygame.image, pygame.font
    from pygame.locals import *
except ImportError:
    print "Error, You don't have the required pygame modules installed"
    raise SystemExit

try:
    import pygame.mixer
except ImportError:
    print "Can't import pygame.mixer, no sound this time round"
    
try:
    from start_up import start_up
    from sound import sound
    from evil_enterprise import evil_enterprise
    from shields import shields
except ImportError:
    raise SystemExit(1)

#init the pygame stuff
try: 
    pygame.init()
    pygame.font.init()
except pygame.error:
    print "Can't init pygame!"
    raise SystemExit(1)

try:
    pygame.mixer.init()
except pygame.error:
    print "No sound available this session"

#some defines

LEFT     = 0
RIGHT    = 1
SHIELDS  = 2
PLANET   = 3
SMALL_P  = 4
MISSILES = 5
EXPLOSION= 6
MINI     = 7
BGD      = 8

RUNNING  = 9
PAUSED   = 10


# and now the fun begins
class game:
    def __init__(self, path):
        """initialises the game stuff, displays the init screen etc"""
	self.scr = pygame.display.set_mode((800, 600)) #FULLSCREEN IN RELEASE MODE
	pygame.display.set_caption("ROTECTOR - LUDUMDARE 48HR")
	start = start_up(path)
	self.sound_serv = sound(os.path.join(path, "sounds"))
	self.evil_bugging_out = []
	self.img = img_loader(path)
	self.level_bonus = 100
	self.number_frames_till_new_level = 0
	self.clk = pygame.time.Clock()
	self.updates = [] # holds a list of dirty_rects
	pygame.key.set_repeat(1, 30)
	self.game_state = RUNNING
	self.planet_rect = pygame.Rect((370, 270, 60, 60))
	self.paused_on = 0
	self.old_score = -1
	self.score = 0
	self.old_level = 1
       	self.level = 1
	self.lives = 3
	self.ships = 2
	self.num_missiles = 10
	self.num_ships = 2
	self.missile_speed = 5 #in pixels per frame
	self.font = pygame.font.Font(None, 30)
	self.explosion_removal = []
	start.show_op()
	self.prep_level()
	return
	
    def prep_level(self):
	if self.level != self.old_level:
	    self.old_level = self.level
	    self.score += self.level_bonus
	    self.level_bonus += 100
	    if (self.level % 2) == 1:
		self.ships += 1
		self.missile_speed += 1
	    self.num_missiles += 1
	self.position = 0
	self.scr.blit(self.img[BGD], (0,0))
	tmp = pygame.font.Font(None, 80).render("LEVEL %s!" %self.level, 1, (180, 30, 30))
	w, h = tmp.get_width(), tmp.get_height()
	x, y = 400 - w / 2, 300 - h / 2
	tmp_img = pygame.Surface((w, h))
	tmp_img.blit(self.img[BGD], (0, 0), (x, y, w, h))
	self.scr.blit(tmp, (x, y))
	pygame.display.flip()
	delay = pygame.time.get_ticks()
	self.scr.blit(tmp_img, (x, y)) # won't be shown till the next update so we can blit the planet etc
	tmp = self.font.render("Score:", 1, (180, 180, 180))
	self.scr.blit(self.img[PLANET], (350, 250))
	self.img[BGD].blit(self.img[PLANET], (350, 250))
	self.shields = shields(self.img)
	x,y = 800 - tmp.get_width() * 2, 3
	self.score_rect = Rect((x, 3, (800 - x) / 2, tmp.get_height() + 3))
	self.scr.blit(tmp, (x - (tmp.get_width() + 5), 3))
	tmp = self.font.render("Level:", 1, (180, 180, 180))
	x,y = 600 - tmp.get_width() * 2, 3
	self.level_rect = Rect((x, 3, (600 - x) / 2, tmp.get_height() + 3))
	self.scr.blit(tmp, (x - (tmp.get_width() + 5), 3))
	self.evil_ents = []
	for i in range(self.ships):
	    self.evil_ents.append(evil_enterprise(self.num_missiles, self.missile_speed,
						  self.img))
	#evil_enterprises start outside the viewable screen and the update() method moves them
	#towards the target

	new_delay = 1500 - (pygame.time.get_ticks() - delay)
	if new_delay > 0:
	    pygame.time.wait(new_delay)
	self.draw_stuff()
	self.shields.draw()
	pygame.display.flip()
	return
	
    def draw_stuff(self):
	for i in range(self.lives - 1): # even tho its 3 lives only need to show 2 graphics
	    self.updates.append(self.scr.blit(self.img[SMALL_P], (i * 35 + 10, 5)))
	self.updates.append(self.scr.blit(self.img[BGD], self.score_rect, self.score_rect))
	self.updates.append(self.scr.blit(self.font.render("%4d" % self.score, 1, (180, 180, 180)),
					      self.score_rect))
	self.updates.append(self.scr.blit(self.img[BGD], self.level_rect, self.level_rect))
	self.updates.append(self.scr.blit(self.font.render("%4d" % self.level, 1, (180, 180, 180)),
					      self.level_rect))

    def loop(self):
        while 1:
	    pygame.event.pump()
	    old_g = self.game_state
            for event in pygame.event.get():
                self.process_event(event)
	    if old_g != self.game_state:   #we got a paused or activeevent
		if self.paused_on:
		    pygame.display.update(self.scr.blit(self.pause_save_img, (self.pause_save_rect)))
		    self.paused_on = 0
		else:
		    tmp_i = pygame.font.Font(None, 80).render("PAUSED", 1, (180, 30, 30))
		    w, h = tmp_i.get_width(), tmp_i.get_height()
		    self.pause_save_rect = Rect((400 - w / 2, 300 - h / 2, w, h))
		    self.pause_save_img = pygame.Surface((w, h))
		    self.pause_save_img.blit(self.scr, (0,0), self.pause_save_rect)
		    pygame.display.update(self.scr.blit(tmp_i, (self.pause_save_rect)))
		    self.paused_on = 1
	    if not self.paused_on:
		self.update()
            self.clk.tick(30)

    def process_event(self, event):
        if event.type == QUIT:
	    raise SystemExit
	elif event.type == KEYDOWN:
	    if event.key == K_ESCAPE or event.key == K_q:
		raise SystemExit
	    elif event.key == K_RIGHT:
		self.shields.move(5)
	    elif event.key == K_LEFT:
		self.shields.move(-5)
	    elif event.key == K_UP:
		self.shields.move(5)
	    elif event.key == K_DOWN:
		self.shields.move(-5)
	    elif event.key == K_p:
		if self.game_state == PAUSED:
		    self.game_state = RUNNING
		else:
		    self.game_state = PAUSED
	elif event.type == VIDEOEXPOSE:
	    pygame.display.flip()
	elif event.type == ACTIVEEVENT:
	    if not pygame.key.get_focused():
		self.game_state = PAUSED
	    else:
		self.game_state = RUNNING
		
    def update(self):
	self.updates = []
	self.missile_rects = []
	self.shields_rects = []
	if len(self.explosion_removal) > 0:
	    for ex in self.explosion_removal:
		self.updates.append(self.scr.blit(self.img[BGD], ex, ex))
	self.explosion_removal = []
	for evil_jtk in self.evil_ents:
	    self.updates.extend(evil_jtk.hide())
	if len(self.evil_bugging_out) > 0:
	    for ev in self.evil_bugging_out:
		self.updates.extend(ev.hide())
	self.updates.extend(self.shields.hide())
	self.draw_stuff()
	for evil_jtk in self.evil_ents:
	    self.updates.extend(evil_jtk.draw())
	if len(self.evil_bugging_out) > 0:
	    for ev in self.evil_bugging_out:
		self.updates.extend(ev.draw())
	self.updates.extend(self.shields.draw())
	pygame.display.update(self.updates)
	self.check_game()

    def check_game(self):
	"""checks for collisions between missiles and shields"""
	self.shields_rects = self.shields.get_rects()
	if len(self.evil_ents) < 1:
	    if self.number_frames_till_new_level == 0:
		self.number_frames_till_new_level = 120#to give them time to leave the screen
	    else:
		self.number_frames_till_new_level -= 1
	if self.number_frames_till_new_level == 1:
	    self.number_frames_till_new_level = 0
	    self.level += 1
	    self.prep_level()
	    self.loop()
	for ev in self.evil_ents:
	    self.missile_rects.extend(ev.get_rects())
	for ev in self.evil_ents:
	    if not ev.missiles_left():
		ev.bug_out()
		self.evil_bugging_out.append(ev)
		self.evil_ents.remove(ev)
	if len(self.missile_rects) < 1:
	    return
	for rect_s in self.shields_rects:
	    for rect_m in self.missile_rects:
		if rect_s.colliderect(rect_m):
		    for ev in self.evil_ents:
			if ev.is_missile(rect_m):
			    rect = ev.kill_missile(rect_m)
			    self.sound_serv.play("explosion.wav")
			    self.score += 10
			    self.explosion_removal.append(rect)

	for ev in self.evil_ents:
	    self.missile_rects.extend(ev.get_rects())
	if len(self.missile_rects) < 1:
	    return
	for i in range(len(self.missile_rects)):
	    if self.planet_rect.colliderect(self.missile_rects[i]):
		for ev in self.evil_ents:
		    if ev.is_missile(self.missile_rects[i]):
			self.explosion()
			pygame.display.flip()
			self.lives -= 1
			if self.lives < 1:
			    self.game_over()
			self.prep_level()
			self.loop()
	return
    
    def explosion(self): #big explosion
	clk = pygame.time.Clock()
	self.sound_serv.play("explosion.wav")
	tmp = self.img[EXPLOSION]
	for i in range(4, 121, 4):
	    pygame.display.update(self.scr.blit(pygame.transform.scale(tmp, (i,i)),
						(400 - i / 2, 300 - i / 2)))
	    clk.tick(15) # 
	return # go the prep level + play the level again
	    

    def game_over(self):
	p = pygame.font.Font(None, 100)
	f = p.render("Game Over", 1, (180, 30, 30))
	self.scr.blit(f, (400 - f.get_width() / 2, 250 - f.get_height() / 2))
	f = p.render("Score: %4d" % self.score, 1, (180, 30, 30))
	self.scr.blit(f, (400 - f.get_width() / 2, 350 - f.get_height() / 2))
	pygame.display.flip()
	pygame.time.wait(1000) #minimum of 1 sec
 	pygame.event.wait()
	raise SystemExit

def img_loader(path):
    names = ["enterprise_left.png",
	     "enterprise_right.png",
	     "shields.png",
	     "home_planet.png",
	     "home_planet_small.png",
	     "missile_strip.png",
	     "explosion30.png",
	     "mini_explosion.png",
	     "bgd.png"]         #these correspond with the global defines
	    
    img = []
    for i in range(BGD): #all but bgd need colorkeyed
	img.append(pygame.image.load(os.path.join(path, "images", names[i])).convert())
	img[i].set_colorkey((0,0,0), pygame.RLEACCEL)

    img.append(pygame.image.load(os.path.join(path, "images", names[BGD])).convert())
    del names
    return img

