import os, sys
import pygame
from Numeric import *
from pygame.locals import *

map_level1 = array(
    (
        (2,2,2,2,2,3,2,2,3,2,2,3,2,2,3,2,2),
        (7,8,7,7,7,7,8,7,7,7,7,7,7,7,7,9,7),
        (12,13,12,12,5,6,13,10,11,12,12,12,12,12,12,14,12),
        (0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)
    ))

map_level2 = array(
    (
        (2,2,2,2,2,3,2,2,3,2,2,3,2,2,3,2,2)+(2,3,3,2,3,3,2,3,3,2,2,3,2,2,2,2,2),
        (8,7,7,7,7,7,8,7,7,7,7,7,7,7,7,9,7)+(7,7,7,7,7,7,8,7,7,7,7,7,7,7,7,9,7),
        (13,12,12,12,5,6,13,10,11,12,12,12,12,12,12,14,12)+(12,12,12,12,5,6,13,10,11,12,12,12,12,12,12,14,12),
        (0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)+(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
    ))

class GameData:

    def load_image(self, name):
        return pygame.image.load(os.path.join('data', name)).convert()

    def load_sound(self, name):
        return pygame.mixer.Sound(os.path.join('data', name))

    def extract_tiles(self, bitmap, width, height):
        tiles = []
        for y in range(0, bitmap.get_height()-1, height):
            for x in range(0, bitmap.get_width()-1, width):
                tiles.append(bitmap.subsurface((x, y, width, height)).convert())
        return tiles

    def calc_flowers_coords(self, map):
        x = 30
        list = []
        for tile in map[0,:]:
            if tile==3:
                list.append((x, 7))
            x += 128

        return list
            

    def load(self):
        self.splash = self.load_image('splash.png')

        self.sprites = self.load_image('sprites.png')

        self.stupid_guy = self.sprites.subsurface((0,144,96,176)).convert()
        self.stupid_guy.set_colorkey((255,0,255), RLEACCEL)

        self.stupid_guy_a = self.sprites.subsurface((256,128,96,176)).convert()
        self.stupid_guy_a.set_colorkey((255,0,255), RLEACCEL)

        self.stupid_guy_b = self.sprites.subsurface((352,128,96,176)).convert()
        self.stupid_guy_b.set_colorkey((255,0,255), RLEACCEL)

        self.stupid_guy_c = self.sprites.subsurface((448,128,96,176)).convert()
        self.stupid_guy_c.set_colorkey((255,0,255), RLEACCEL)

        self.stupid_guy_anim = [ self.stupid_guy_a, self.stupid_guy_b, self.stupid_guy_c, self.stupid_guy_b ]

        self.stupid_guy_dead = self.sprites.subsurface((256,0,176,112)).convert()
        self.stupid_guy_dead.set_colorkey((255,0,255), RLEACCEL)

        self.angel_right = self.sprites.subsurface((0,0,103,117)).convert()
        self.angel_right.set_colorkey((255,0,255), RLEACCEL)

        self.angel_left = self.sprites.subsurface((151,0,103,117)).convert()
        self.angel_left.set_colorkey((255,0,255), RLEACCEL)

        self.flowers = self.sprites.subsurface((0,320,80,96)).convert() 
        self.flowers.set_colorkey((255,0,255), RLEACCEL)

        self.dog = self.sprites.subsurface((432,0,182,120)).convert()
        self.dog.set_colorkey((255,0,255), RLEACCEL)

        self.dog_b = self.sprites.subsurface((416,304,182,120)).convert()
        self.dog_b.set_colorkey((255,0,255), RLEACCEL)

        self.dog_anim = [self.dog, self.dog_b]

        self.skater = self.sprites.subsurface((96,128,122,168)).convert()
        self.skater.set_colorkey((255,0,255), RLEACCEL)

        self.tiles = self.extract_tiles(self.load_image('tiles.png'), 128, 128)

        self.snd_dog = self.load_sound('dog.wav')
        self.snd_flowers = self.load_sound('bomb.wav')
        self.snd_skater = self.load_sound('skater.wav')
        self.snd_skater_dead = self.load_sound('ohw.wav')
        self.snd_angel_action = self.load_sound('shbow.wav')
        self.snd_dead = self.load_sound('kenny.wav')
        self.snd_what = self.load_sound('whatareyou.wav')

        self.font = pygame.font.Font(None, 48)

        self.levels = (
            {
            'title': "Level 1 - A quiet day",
            'map': map_level1,
            'flowers': self.calc_flowers_coords(map_level1),
            'dogs': [400, 800, 1200],
            'skaters': [600, 1000, 1200]
            },
            {
            'title': "Level 2 - A bit harder",
            'map': map_level2,
            'flowers': self.calc_flowers_coords(map_level2),
            'dogs': [600, 1500, 2000, 2200, 2300, 2750, 3000, 3050, 3100],
            'skaters': [400, 900, 1500, 2200, 2500, 2600, 2700, 3025, 3075, 3100]
            }
            )

gamedata = GameData()
