#Import Modules
import os, pygame, string
from pygame.locals import *
from random import Random
from time import clock

from io_funcs import *

from string import *


if not pygame.font: raise SystemExit, "Requires pygame.font module"
if not pygame.mixer: print 'Warning, sound disabled'


#classes for our game objects
class MySprite (pygame.sprite.Sprite):
	"""moves a clenched paddle on the screen, following the mouse"""
	def __init__(self, filename, transparency, type, x, y):
		pygame.sprite.Sprite.__init__(self) #call Sprite initializer
		self.type = type
		self.image, self.rect = load_image(filename)
		if transparency == 1:
			colorkey = self.image.get_at((0,0))
			self.image.set_colorkey(colorkey, RLEACCEL)
		self.active = 1
		self.rect.left =   x
		self.rect.top =  y
		self.posX = x
		self.posY = y
		self.visible = 1

class Actor:
	def __init__ (self, guy, expressions, pos):
		"""Takes in args for the guys description (body, hair), expression list (lists of eyes, pupils, brows, mouth), and the position on the screen)"""
		self.guy = guy
		self.expressions = expressions
		self.pos = pos

		# List of sprites
		self.sprites_face = []
		self.sprites_face_over = []
		
		self.num_frames = 0		# Clear # of frames
		count = 0				# Temporary counter, since we're inserting frames as well
		for expression in expressions:
			# If this is an even frame, add a blink
			if self.num_frames % 2 == 0:
				# Load the images for the guy - but with a FORCED BLINK
				(self.sprites_guy, face_list, face_over_list, self.sprites_face_hair) = loadGuy (self.guy[0], self.guy[1], 2, -1, -1, 0, pos)
				
				# Append the lists over the faces
				self.sprites_face.append (face_list)
				self.sprites_face_over.append (face_over_list)
				
				self.num_frames += 1		# Increment number of frames
			
			# Load the images for the guy
			(self.sprites_guy, face_list, face_over_list, self.sprites_face_hair) = loadGuy (self.guy[0], self.guy[1], self.expressions[count][0], self.expressions[count][1], self.expressions[count][2], self.expressions[count][3], pos)
			
			# Append the lists over the faces
			self.sprites_face.append (face_list)
			self.sprites_face_over.append (face_over_list)
			
			self.num_frames += 1		# Increment number of frames
			count += 1					# Increment temporary counter

		# Seed random stuff
		random = Random ()
		random.seed (pos[0] * clock() )	# Stupid seed
		
		# Counter timer
		self.tick_counter = random.randint (-1000, 1000)
		self.frame_cur = random.randint (0, self.num_frames-1)


	def update (self, screen, gameEvent):
		"""Update the animation, and draw the actor"""
		
		# Update tick counter
		
		# Set frame - blinks are even frames and shorter
		if self.frame_cur % 2 == 0 and gameEvent.ticks - self.tick_counter > 500:	# .5 second delay
			self.frame_cur += 1						# Increment frame
			self.tick_counter = gameEvent.ticks		# Reset tick counter
		elif self.frame_cur == 1 and gameEvent.ticks - self.tick_counter > 3500:	# 2 second delay
			self.frame_cur += 1						# Increment frame
			self.tick_counter = gameEvent.ticks		# Reset tick counter
		elif self.frame_cur % 2 != 0 and self.frame_cur != 1 and gameEvent.ticks - self.tick_counter > 1300:	# 1 second delay
			self.frame_cur += 1						# Increment frame
			self.tick_counter = gameEvent.ticks		# Reset tick counter
		
		# Keep the frames in bounds, and loop
		if (self.frame_cur >= self.num_frames):
			self.frame_cur = 0
		
		# Draw the guy
		self.sprites_guy.draw (screen)			# No frames for the guy
		
		# Draw expressions with the current frame
		self.sprites_face[self.frame_cur].draw (screen)
		self.sprites_face_over[self.frame_cur].draw (screen)
		
		self.sprites_face_hair.draw (screen)	# No frames for hair
		
		return 0


class GameEvent:
	"""Event system wrapped so that it is based on time things were pressed.  
		Otherwise repeats occur that we dont desire."""
		
	def __init__(self):
		# Setup the keystate and keystateTime initial values
		self.keystate = pygame.key.get_pressed()
		i = 0	# Reset the counter
		self.keystateTime = []
		for key in self.keystate:
			self.keystateTime.insert (0, 0)	# Inserting null values just allows things to be set up for later, so the list is in order
			i += 1

		# Variable for Window event close
		self.winClose = 0
		
		# Keys currently pressed down making a string.  The idea is that this is normally one, then you can append this string to a name to accept input
		self.keyString = ""
		self.keyStringTime = 0		# ticks when this was last updated

		# Default mouse button state.  All off
		self.mouseButtons = [0, 0, 0]

		# Run update to init all the variables
		self.update()

	def update(self):
		"""Update the input"""
		# Loop through all the events
		for event in pygame.event.get():
			if event.type is QUIT:
				self.winClose = 1
		
		# Get the key state
		self.keystate = pygame.key.get_pressed()
		
		# Get the time
		self.ticks = pygame.time.get_ticks()

		# Get the mouse data
		self.mousePos = pygame.mouse.get_pos()			# Position
		cur_buttons = pygame.mouse.get_pressed();		# Current button states
		# Update stored states if buttons are down that weren't before
		for button in range (0,2):
			# If the button was pressed, and was not pressed before
			if cur_buttons[button] == 1 and self.mouseButtons[button] == 0:
				self.mouseButtons[button] = self.ticks	# Store the time of this click
			elif cur_buttons[button] == 0:
				self.mouseButtons[button] = 0			# Store a zero value, the button is not down
	
		# Get the time of each key states
		i = 0	# Reset the counter
		curKeyString = []
		for key in self.keystate:
			if not key:
				self.keystateTime[i] = 0
			elif self.keystateTime[i] == 0:
				self.keystateTime[i] = self.ticks

				# Append to key string if its valid
				if i != K_UP and i != K_DOWN and i != K_RIGHT and i != K_LEFT and i != K_ESCAPE and i != K_RETURN and i != K_BACKSPACE and i <= 127:
					curKeyString.append (chr(i))
			
			i += 1	# Increment the counter
		
		# Fix case if shift is being held down
		curKeyString = string.join (curKeyString,"")
		if self.keystate[K_LSHIFT] or self.keystate[K_RSHIFT]:
			curKeyString = curKeyString.upper()
			curKeyString = curKeyString.replace ("1", "!")
			curKeyString = curKeyString.replace ("2", "@")
			curKeyString = curKeyString.replace ("3", "#")
			curKeyString = curKeyString.replace ("4", "$")
			curKeyString = curKeyString.replace ("5", "%")
			curKeyString = curKeyString.replace ("6", "^")
			curKeyString = curKeyString.replace ("7", "&")
			curKeyString = curKeyString.replace ("8", "*")
			curKeyString = curKeyString.replace ("9", "(")
			curKeyString = curKeyString.replace ("0", ")")
			curKeyString = curKeyString.replace ("[", "{")
			curKeyString = curKeyString.replace ("]", "}")
			curKeyString = curKeyString.replace ("/", "?")
			curKeyString = curKeyString.replace ("=", "+")
			curKeyString = curKeyString.replace ("'", "\"")
			curKeyString = curKeyString.replace (",", "<")
			curKeyString = curKeyString.replace (".", ">")
			
		# Compare the keyStrings, if they aren't the same, then its changed and save the new one
		if curKeyString == "":
			self.keyString = ""
			self.keyStringTime = 0
		elif str(self.keyString) != curKeyString:
			self.keyString = curKeyString
			self.keyStringTime = self.ticks

		return

class VictoryMode:
	def __init__ (self):
		# Load the background screen
		self.sprites_back = pygame.sprite.RenderPlain ()
		self.gameBack = MySprite ("win.bmp", 0 , 1, 0, 0)
		self.sprites_back.add (self.gameBack)
		
		# Initialize the actors
		self.actor1 = Actor ( [-1, -1], [ [0, 0, 0, 0], [0, 0, 1, 0]  ], (16,90) )
		self.actor2 = Actor ( [-1, -1], [ [0, 0, 0, 0], [0, 0, 1, 0]  ], (157,90) )
		self.actor3 = Actor ( [-1, -1], [ [0, 0, 0, 0], [0, 0, 1, 0] ], (316,90) )
		self.actor4 = Actor ( [-1, -1], [ [0, 0, 0, 0], [0, 0, 1, 0] ], (470,90) )
		
		self.actor5 = Actor ( [-1, -1], [ [0, 0, 0, 0], [0, 0, 1, 0] ], (6,279) )
		self.actor6 = Actor ( [-1, -1], [ [0, 0, 0, 0], [0, 0, 1, 0]  ], (165,279) )
		self.actor7 = Actor ( [-1, -1], [ [0, 0, 0, 0], [0, 0, 1, 0] ], (311,279) )
		self.actor8 = Actor ( [-1, -1], [ [0, 0, 0, 0], [0, 0, 1, 0] ], (470,279) )

	def update (self, screen, gameEvent):
		# Draw the background
		self.sprites_back.draw (screen)

		# Draw actors
		self.actor1.update (screen, gameEvent)
		self.actor2.update (screen, gameEvent)
		self.actor3.update (screen, gameEvent)
		self.actor4.update (screen, gameEvent)
		self.actor5.update (screen, gameEvent)
		self.actor6.update (screen, gameEvent)
		self.actor7.update (screen, gameEvent)
		self.actor8.update (screen, gameEvent)

		if gameEvent.mouseButtons[0] == gameEvent.ticks:
			return (1)

		return (0)

class LoseMode:
	def __init__ (self):
		# Load the background screen
		self.sprites_back = pygame.sprite.RenderPlain ()
		self.gameBack = MySprite ("lose.bmp", 0 , 1, 0, 0)
		self.sprites_back.add (self.gameBack)
		
		# Initialize the actors
		self.actor1 = Actor ( [-1, -1], [ [0, 0, 0, 0], [0, 0, 1, 0]  ], (16,90) )
		self.actor2 = Actor ( [-1, -1], [ [0, 0, 0, 0], [0, 0, 1, 0]  ], (157,90) )
		self.actor3 = Actor ( [-1, -1], [ [0, 0, 0, 0], [0, 0, 1, 0] ], (316,90) )
		self.actor4 = Actor ( [-1, -1], [ [0, 0, 0, 0], [0, 0, 1, 0] ], (470,90) )
		
		self.actor5 = Actor ( [-1, -1], [ [0, 0, 0, 0], [0, 0, 1, 0] ], (6,279) )
		self.actor6 = Actor ( [-1, -1], [ [0, 0, 0, 0], [0, 0, 1, 0]  ], (165,279) )
		self.actor7 = Actor ( [-1, -1], [ [0, 0, 0, 0], [0, 0, 1, 0] ], (311,279) )
		self.actor8 = Actor ( [-1, -1], [ [0, 0, 0, 0], [0, 0, 1, 0] ], (470,279) )

	def update (self, screen, gameEvent):
		# Draw the background
		self.sprites_back.draw (screen)

		# Draw actors
		self.actor1.update (screen, gameEvent)
		self.actor2.update (screen, gameEvent)
		self.actor3.update (screen, gameEvent)
		self.actor4.update (screen, gameEvent)
		self.actor5.update (screen, gameEvent)
		self.actor6.update (screen, gameEvent)
		self.actor7.update (screen, gameEvent)
		self.actor8.update (screen, gameEvent)

		if gameEvent.mouseButtons[0] == gameEvent.ticks:
			return (1)
		
		return (0)

class TitleMode:
	def __init__ (self):
		# Load the background screen
		self.sprites_back = pygame.sprite.RenderPlain ()
		self.gameBack = MySprite ("title.bmp", 0 , 1, 0, 0)
		self.sprites_back.add (self.gameBack)

	def update (self, screen, gameEvent):
		# Draw the background
		self.sprites_back.draw (screen)

		if gameEvent.mouseButtons[0] == gameEvent.ticks:
			return (1)
		
		return (0)
		

class GameMode:
	def __init__ (self, max_event):
		self.max_event = 3			# Last event for us
		self.event = 1				# Starting event
		self.event_result = 0		# Event result (or not)
		
		self.actor_pos = (464, 137)	# Lined up at this position with the background
		
		# Game variables
		self.money = 1000
		self.feeb_approval = 50
		self.war = 0
		self.attakistan_rel = 50
		self.angrolia_rel = 50
		self.casherica_rel = 50
		self.virtulund_rel = 50
		self.trubeld_rel = 200

		# Load the background screen
		self.sprites_back = pygame.sprite.RenderPlain ()
		self.gameBack = MySprite ("ui_screen.bmp", 0 , 1, 0, 0)
		self.sprites_back.add (self.gameBack)
		
		# Load the initial event
		self.loadEvent ()
		
	def proceed (self, option):
		# Check to make sure none of the Game State variables have fallen below acceptable limit
		if self.money <= 0 or self.feeb_approval <= 0 or self.war == 1:
			return (-1)		# The game has been lost!
	
		# If this was an event, and not the result
		if self.event_result == 0:
			# Load the event result
			self.event_result = option
			self.loadEvent ()
		# Else, this was an event result	
		else:
			# Proceed to the next stage
			self.event += 1
			self.event_result = 0
			if self.event > self.max_event:
				return (1)		# The game has been won!
			else:
				self.loadEvent ()
				return (0)		# Normal return.  Continue playing

	def loadEvent (self):
		# Load the event
		(self.unique, self.guy, self.expressions, self.title, self.problems, self.choices, self.event_result, self.stat_action, self.sound_type) = loadEvent (self.event, self.event_result)

		# Create the Actor based on the guy and expressions we loaded up
		self.actor = Actor (self.guy, self.expressions, self.actor_pos );		
		
		# Process the stat changes in the event we just loaded
		if self.stat_action[0] == 0:
			self.money += self.stat_action[1]		# Adjust the amount
		elif self.stat_action[0] == 1:
			self.feeb_approval += self.stat_action[1]		# Adjust the amount
		elif self.stat_action[0] == 2:
			self.attakistan_rel += self.stat_action[1]		# Adjust the amount
		elif self.stat_action[0] == 3:
			self.angrolia_rel += self.stat_action[1]		# Adjust the amount
		elif self.stat_action[0] == 4:
			self.casherica_rel += self.stat_action[1]		# Adjust the amount
		elif self.stat_action[0] == 5:
			self.virtulund_rel += self.stat_action[1]		# Adjust the amount
		elif self.stat_action[0] == 6:
			self.trubeld_rel += self.stat_action[1]			# Adjust the amount
		
		# Set strings basedon relationships
		if self.feeb_approval > 70:
			self.feeb_approval_str = "Good"
		elif self.feeb_approval < 30:
			self.feeb_approval_str = "Bad"
		elif self.feeb_approval < 10:
			self.feeb_approval_str = "Dismal"
		else:
			self.feeb_approval_str = "Normal"

		if self.attakistan_rel > 70:
			self.attakistan_str = "Good"
		elif self.attakistan_rel < 30:
			self.attakistan_str = "Bad"
		elif self.attakistan_rel < 10:
			self.attakistan_str = "Dismal"
		else:
			self.attakistan_str = "Normal"

		if self.angrolia_rel > 70:
			self.angrolia_str = "Good"
		elif self.angrolia_rel < 30:
			self.angrolia_str = "Bad"
		elif self.angrolia_rel < 10:
			self.angrolia_str = "Dismal"
		else:
			self.angrolia_str = "Normal"

		if self.casherica_rel > 70:
			self.casherica_str = "Good"
		elif self.casherica_rel < 30:
			self.casherica_str = "Bad"
		elif self.casherica_rel < 10:
			self.casherica_str = "Dismal"
		else:
			self.casherica_str = "Normal"

		if self.virtulund_rel > 70:
			self.virtulund_str = "Good"
		elif self.virtulund_rel < 30:
			self.virtulund_str = "Bad"
		elif self.virtulund_rel < 10:
			self.virtulund_str = "Dismal"
		else:
			self.virtulund_str = "Normal"

		if self.trubeld_rel > 70:
			self.trubeld_str = "Good"
		elif self.trubeld_rel < 30:
			self.trubeld_str = "Bad"
		elif self.trubeld_rel < 10:
			self.trubeld_str = "Dismal"
		else:
			self.trubeld_str = "Normal"

	def update (self, screen, gameEvent):
		# Draw the background
		self.sprites_back.draw (screen)

		# Draw the actor
		self.actor.update (screen, gameEvent);

		# Draw tex for expression debugging
		#draw_text ("Guy: %i " % self.actor.guy[0] + "Hair: %i " % self.actor.guy[1] + "Eyes: %i " % self.actor.expressions[0][0] + "Pupils: %i " % self.actor.expressions[0][1] + "Brow: %i " % self.actor.expressions[0][2] + "Mouth: %i" % self.actor.expressions[0][3], 23, (255,255,255), [ [20,96] , [200,300] ] , screen)

		# Draw game state variables
		text_size = 20
		text_y = 9
		draw_text ("Money: %i" % self.money, 20, (255,255,255), [ [20,text_y] , [426,125] ] , screen)
		text_y += text_size -3
		draw_text ("Feeb Approval: " , 20, (255,255,255), [ [20,text_y] , [426,125] ] , screen)
		draw_text (self.feeb_approval_str, 20, (255,255,255), [ [180,text_y] , [426,125] ] , screen)
		text_y += text_size -3
		text_y += text_size -3
		draw_text ("Attackistan Relations: ", 20, (255,255,255), [ [20,text_y] , [426,125] ] , screen)
		draw_text (self.attakistan_str, 20, (255,255,255), [ [180,text_y] , [426,125] ] , screen)
		text_y += text_size -3
		draw_text ("Angrolia Relations: ", 20, (255,255,255), [ [20,text_y] , [426,125] ] , screen)
		draw_text (self.angrolia_str, 20, (255,255,255), [ [180,text_y] , [426,125] ] , screen)
		text_y += text_size -3
		draw_text ("Casherica Relations: ", 20, (255,255,255), [ [20,text_y] , [426,125] ] , screen)
		draw_text (self.casherica_str, 20, (255,255,255), [ [180,text_y] , [426,125] ] , screen)
		text_y += text_size -3
		draw_text ("Virtulund Relations: ", 20, (255,255,255), [ [20,text_y] , [426,125] ] , screen)
		draw_text (self.virtulund_str, 20, (255,255,255), [ [180,text_y] , [426,125] ] , screen)
		text_y += text_size -3
		if self.trubeld_rel != 200:		# 200 is the default, cause you dont know about them yet
			draw_text ("Virtulund Relations: ", 20, (255,255,255), [ [20,text_y] , [426,125] ] , screen)
			draw_text (self.trubeld_str, 20, (255,255,255), [ [20,text_y] , [426,125] ] , screen)

		# Draw title
		draw_text (self.title, 34, (255,255,255), [ [20,145] , [417,145+40] ] , screen)

		# Draw problem
		problem_size = 16
		problem_y_start = 185
		for problem in self.problems:
			draw_text (problem, problem_size, (255,255,255), [ [20,problem_y_start] , [417,320] ] , screen)
			problem_y_start += problem_size + 3

		# Clear the choice rect list
		choice_rect_list = []

		# Draw choices
		choice_size = 16
		choice_y_start = 352
		choice_num = 0
		for choice in self.choices:
			choice_y_initial = choice_y_start
			for line in choice:
				rect = [ [20,choice_y_start] , [625,474] ]		# Line Boundary rectangle
				draw_text (line, choice_size, (255,255,255), rect, screen)
				choice_y_start += choice_size - 2

			# Selection Boundary rectangle - from where we started, to where we are now
			choice_rect_list.append ( [ [10,choice_y_initial] , [605, (choice_y_start + 2) - choice_y_initial ] ] )
			
			# Add space to separate the next choice
			choice_y_start += 10
			
			# Increment the number of choices.  Have to do this to access the choice_rect_list current elements
			choice_num += 1

		# Cycle through the choices to check the list, and draw select boxes
		for selection in range (0, choice_num):
			# If the mouse is inside the choice rectangle
			py_rect = pygame.Rect (choice_rect_list[selection] )
			if py_rect.collidepoint ( pygame.mouse.get_pos () ):
				# Draw a box around this selection
				pygame.draw.rect (screen, [255,255,255], py_rect, 1)
				
				# Get the mouse button
				(button1, button2, button3) = pygame.mouse.get_pressed()
				
				# If the button is pressed
				if gameEvent.mouseButtons[0] == gameEvent.ticks:
					return ( self.proceed (selection+1) )		# Proceed with the game, return the result, as it may be the end of the game or mode

		return (0)		# End of the update, no changes to report		
	

def loadGuy(guy, hair, eyes, pupils, brow, mouth, pos):
	"""This Function loads a guy, and returns a collection of RenderPlains with the guy's images"""

	# Create the render groups
	sprites_guy = pygame.sprite.RenderPlain ()
	sprites_face = pygame.sprite.RenderPlain ()
	sprites_face_over = pygame.sprite.RenderPlain ()
	sprites_face_hair = pygame.sprite.RenderPlain ()

	# Loads the images, create sprites
	if (guy != -1):
		gameGuy = MySprite ("actors/actor_%i.bmp" % guy, 0 , 1, pos[0], pos[1])
	else:
		gameGuy = 0

	gameGuyEyes = MySprite ("actors/expression/eyes_%i.bmp" % eyes, 1 , 1, pos[0], pos[1])
	
	if (pupils != -1):
		gameGuyPupil = MySprite ("actors/expression/pupil_%i.bmp" % pupils, 1 , 1, pos[0], pos[1])
	else:
		gameGuyPupil = 0
		
	if (brow != -1):
		gameGuyBrow = MySprite ("actors/expression/brow_%i.bmp" % brow, 1 , 1, pos[0], pos[1])
	else:
		gameGuyBrow = 0
		
	if (hair != -1):
		gameGuyHair = MySprite ("actors/expression/hair_%i.bmp" % hair, 1 , 1, pos[0], pos[1])
	else:
		gameGuyHair = 0
		
	gameGuyMouth = MySprite ("actors/expression/mouth_%i.bmp" % mouth, 1 , 1, pos[0], pos[1])


	# Add the sprites to the render groups
	if (gameGuy != 0):
		sprites_guy.add (gameGuy)
	
	if (gameGuyPupil != 0):
		sprites_face.add (gameGuyPupil)
	sprites_face.add (gameGuyEyes)
	
	if (gameGuyBrow != 0):
		sprites_face_over.add (gameGuyBrow)
	sprites_face_over.add (gameGuyMouth)
	
	if (gameGuyHair != 0):
		sprites_face_hair.add (gameGuyHair)
	
	# Return the render groups
	return (sprites_guy, sprites_face, sprites_face_over, sprites_face_hair)
	

def loadEvent (num, event_result):
	"""Load an event out of the event directory, that describes the current situation"""
	if event_result == 0:
		file = open ("data/event/%i.txt" % num, 'r')	# Open the event file
	else:
		file = open ("data/event/%i_%i.txt" % (num, event_result-1), 'r')	# Open the event result file
		
	
	# Read the unique line (0 = repeatable, 1 = unique)
	unique = string.atoi ( file.readline () )
	
	# Get the character description
	(str_guy, str_hair) = string.split ( file.readline () )
	actor = [ string.atoi (str_guy) , string.atoi (str_hair) ]
	
	# Get the number of expressions
	num_expressions = string.atoi ( file.readline () )
	
	# Create the expressions list
	expressions = []
	
	# Loop through the expressions
	for count in range (0, num_expressions):
		# Read in the line from the file and process
		(str_eyes, str_pupils, str_brow, str_mouth) = string.split ( file.readline () )
		expressions.append ( [ string.atoi (str_eyes), string.atoi (str_pupils), string.atoi (str_brow), string.atoi (str_mouth) ] )
	
	# Get the name of the guy (or title)
	title = string.replace ( file.readline (), '\n', '')

	# Create the expressions list
	problems = []
	
	# Loop through the choices
	line = ""
	while line != "-\n":
		# Read in the line from the file and process
		line = file.readline ()
		if line != "-\n":
			problems.append ( string.replace (line, '\n', '') )

	# Get the number of choices
	num_choices = string.atoi ( file.readline () )
	
	# Create the expressions list
	choices = []
	
	# Loop through the choices
	for count in range (0, num_choices):
		# Read in the line from the file and process
		line = ""
		line_list = []
		while line != "-\n":
			# Read in the line from the file and process
			line = file.readline ()
			if line != "-\n":
				line_list.append ( string.replace (line, '\n', '') )

		choices.append ( line_list )	# Add the list of lines we just loaded
	
	# Get the character description
	(str_stat, str_amount) = string.split ( file.readline () )
	stat_action = [ string.atoi (str_stat) , string.atoi (str_amount) ]

	# Get the sound to play
	sound_type = string.atoi ( file.readline () )

	return (unique, actor, expressions, title, problems, choices, event_result, stat_action, sound_type)
	
	
def main():
	"""this function is called when the program starts.
	   it initializes everything it needs, then runs in
	   a loop until the function returns."""

	# Set the max event.  If they survive this far, they win!
	max_event = 2

	#Initialize Everything
	pygame.init ()
	screen = pygame.display.set_mode ((640, 480))
	pygame.display.set_caption ('48-Hour Game: Protect Feebania!    by Geoff Howland    http://ludumdare.com/')
	
	#Create The Backgound
	background = pygame.Surface (screen.get_size())
	
	# Create clock to lock framerate
	clock = pygame.time.Clock ()
	
	# Set up the game event class to handle gathering input
	gameEvent = GameEvent ()
	
	# Create the modes
	titleMode = TitleMode ()
	victoryMode = VictoryMode ()
	loseMode = LoseMode ()
	gameMode = GameMode (2)	# Init the game state with 2 max levels
	
	modes = [ titleMode, gameMode, loseMode, victoryMode ]
	cur_mode = 0 

	# Main Loop
	while 1:
		# Lock the framerate
		clock.tick (60)

		# Process the game events
		gameEvent.update ()

		if gameEvent.keystate[K_ESCAPE]:
			return		# Leave the game
			
		if gameEvent.keystate[K_a]:
			gameMode.guy[0] += 1
			if gameMode.guy[0] > 8:
				gameMode.guy[0] = 0
			gameMode.actor = Actor (gameMode.guy, gameMode.expressions, gameMode.actor_pos );
	
		if gameEvent.keystate[K_s]:
			gameMode.guy[1] += 1
			if gameMode.guy[1] > 6:
				gameMode.guy[1] = -1
			gameMode.actor = Actor (gameMode.guy, gameMode.expressions, gameMode.actor_pos );
		
		if gameEvent.keystate[K_d]:
			gameMode.expressions[0][0] += 1
			if gameMode.expressions[0][0] > 2:
				gameMode.expressions[0][0] = 0
			gameMode.actor = Actor (gameMode.guy, gameMode.expressions, gameMode.actor_pos );
		
		if gameEvent.keystate[K_f]:
			gameMode.expressions[0][1] += 1
			if gameMode.expressions[0][1] > 3:
				gameMode.expressions[0][1] = -1
			gameMode.actor = Actor (gameMode.guy, gameMode.expressions, gameMode.actor_pos );
		
		if gameEvent.keystate[K_g]:
			gameMode.expressions[0][2] += 1
			if gameMode.expressions[0][2] > 2:
				gameMode.expressions[0][2] = -1
			gameMode.actor = Actor (gameMode.guy, gameMode.expressions, gameMode.actor_pos );
		
		if gameEvent.keystate[K_h]:
			gameMode.expressions[0][3] += 1
			if gameMode.expressions[0][3] > 7:
				gameMode.expressions[0][3] = 0
			gameMode.actor = Actor (gameMode.guy, gameMode.expressions, gameMode.actor_pos );

		# Update the game state - draw and such.  Result == 0, continue.  == -1, lost game.  == 1 won game.
		result = modes[cur_mode].update (screen, gameEvent)
		
		# If this is the title mode, check result
		if cur_mode == 0 and result == 1:
			cur_mode = 1	# Switch to game mode
		# Else, If the current mode is GameMode, check result
		elif cur_mode == 1 and result == -1:
			cur_mode = 2	# Lose mode
		elif cur_mode == 1 and result == 1:
			cur_mode = 3	# Victory mode
		elif (cur_mode == 2 or cur_mode == 3) and result == 1:
			return			# Game over

		# Flip to front
		pygame.display.flip ()


#this calls the 'main' function when this script is executed
if __name__ == '__main__': main()
