"""
High Level IO functions: images, sounds and fonts
"""

#Import Modules
import os, pygame
from pygame.locals import *
from random import randint

def load_image(name, colorkey=None):
	fullname = os.path.join('data', name)
	try:
		image = pygame.image.load(fullname)
	except pygame.error, message:
		print 'Cannot load image:', fullname
		raise SystemExit, message
	image = image.convert()
	if colorkey is not None:
		if colorkey is -1:
			colorkey = image.get_at((0,0))
		image.set_colorkey(colorkey, RLEACCEL)
	return image, image.get_rect()

def load_sound(name):
	class NoneSound:
		def play(self): pass
	if not pygame.mixer or not pygame.mixer.get_init():
		return NoneSound()
	fullname = os.path.join('data', name)
	try:
		sound = pygame.mixer.Sound(fullname)
	except pygame.error, message:
		print 'Cannot load sound:', fullname
		raise SystemExit, message
	return sound


def draw_text (text, size, color, pos, surface):
	"""Draw text of a given font size onto a surface"""
	if pygame.font:
		font = pygame.font.Font ("bluebold.ttf", size)
		text_font = font.render (text, 1, color)
		surface.blit (text_font, pos)
